/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.xml;

import codeguard.licensing.klp;
import codeguard.licensing.zhj;
import de.schlichtherle.xml.GenericCertificateIntegrityException;
import de.schlichtherle.xml.GenericCertificateIsLockedException;
import de.schlichtherle.xml.GenericCertificateNotLockedException;
import de.schlichtherle.xml.PersistenceServiceException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.commons.codec.binary.Base64;

public final class GenericCertificate
implements zhj,
Serializable {
    private static final long serialVersionUID = 6247620498526484734L;
    private static final String dyd = "US-ASCII";
    private static final String ews = "US-ASCII/Base64";
    private transient boolean pid;
    private String yaf;
    private String signature;
    private String lbx;
    private String cpa;
    private transient PropertyChangeSupport evy;
    private transient VetoableChangeSupport bcd;

    public GenericCertificate() {
    }

    public GenericCertificate(GenericCertificate genericCertificate) {
        try {
            this.setEncoded(genericCertificate.getEncoded());
            this.setSignature(genericCertificate.getSignature());
            this.setSignatureAlgorithm(genericCertificate.getSignatureAlgorithm());
            this.setSignatureEncoding(genericCertificate.getSignatureEncoding());
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new AssertionError((Object)propertyVetoException);
        }
    }

    public final synchronized void sign(Object object, PrivateKey privateKey, Signature signature) throws NullPointerException, GenericCertificateIsLockedException, PropertyVetoException, PersistenceServiceException, InvalidKeyException {
        if (privateKey == null) {
            throw new NullPointerException("signingKey");
        }
        if (signature == null) {
            throw new NullPointerException("signingEngine");
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "locked", this.isLocked(), Boolean.TRUE);
        if (this.isLocked()) {
            throw new GenericCertificateIsLockedException(propertyChangeEvent);
        }
        this.fireVetoableChange(propertyChangeEvent);
        try {
            byte[] byArray = klp.zxn(object);
            signature.initSign(privateKey);
            signature.update(byArray);
            byte[] byArray2 = Base64.encodeBase64((byte[])signature.sign());
            String string = new String(byArray2, 0, byArray2.length, dyd);
            this.setEncoded(new String(byArray, "UTF-8"));
            this.setSignature(string);
            this.setSignatureAlgorithm(signature.getAlgorithm());
            this.setSignatureEncoding(ews);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
        catch (SignatureException signatureException) {
            throw new AssertionError((Object)signatureException);
        }
        this.pid = true;
        this.firePropertyChange(propertyChangeEvent);
    }

    public final synchronized void verify(PublicKey publicKey, Signature signature) throws NullPointerException, GenericCertificateIsLockedException, PropertyVetoException, InvalidKeyException, SignatureException, GenericCertificateIntegrityException {
        if (publicKey == null) {
            throw new NullPointerException("verificationKey");
        }
        if (signature == null) {
            throw new NullPointerException("verificationEngine");
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "locked", this.isLocked(), Boolean.TRUE);
        if (this.isLocked()) {
            throw new GenericCertificateIsLockedException(propertyChangeEvent);
        }
        this.fireVetoableChange(propertyChangeEvent);
        try {
            byte[] byArray = this.getEncoded().getBytes("UTF-8");
            signature.initVerify(publicKey);
            signature.update(byArray);
            byte[] byArray2 = Base64.decodeBase64((byte[])this.getSignature().getBytes(dyd));
            if (!signature.verify(byArray2)) {
                throw new GenericCertificateIntegrityException();
            }
            this.setSignatureAlgorithm(signature.getAlgorithm());
            this.setSignatureEncoding(ews);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
        this.pid = true;
        this.firePropertyChange(propertyChangeEvent);
    }

    public final boolean isLocked() {
        return this.pid;
    }

    public Object getContent() throws GenericCertificateNotLockedException, PersistenceServiceException {
        if (!this.isLocked()) {
            throw new GenericCertificateNotLockedException();
        }
        return klp.zxn(this.getEncoded());
    }

    public final String getEncoded() {
        return this.yaf;
    }

    public synchronized void setEncoded(String string) throws GenericCertificateIsLockedException {
        if (string == null ? this.yaf == null : string.equals(this.yaf)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "encoded", this.getEncoded(), string);
        if (this.isLocked()) {
            throw new GenericCertificateIsLockedException(propertyChangeEvent);
        }
        this.yaf = string;
        this.firePropertyChange(propertyChangeEvent);
    }

    public final String getSignature() {
        return this.signature;
    }

    public synchronized void setSignature(String string) throws GenericCertificateIsLockedException {
        if (string == null ? this.signature == null : string.equals(this.signature)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "signature", this.getSignature(), string);
        if (this.isLocked()) {
            throw new GenericCertificateIsLockedException(propertyChangeEvent);
        }
        this.signature = string;
        this.firePropertyChange(propertyChangeEvent);
    }

    public final String getSignatureAlgorithm() {
        return this.lbx;
    }

    public synchronized void setSignatureAlgorithm(String string) throws GenericCertificateIsLockedException {
        if (string == null ? this.lbx == null : string.equals(this.lbx)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "signatureAlgorithm", this.getSignatureAlgorithm(), string);
        if (this.isLocked()) {
            throw new GenericCertificateIsLockedException(propertyChangeEvent);
        }
        this.lbx = string;
        this.firePropertyChange(propertyChangeEvent);
    }

    public final String getSignatureEncoding() {
        return this.cpa;
    }

    public synchronized void setSignatureEncoding(String string) throws GenericCertificateIsLockedException {
        if (string == null ? this.cpa == null : string.equals(this.cpa)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "signatureEncoding", this.getSignatureEncoding(), string);
        if (this.isLocked()) {
            throw new GenericCertificateIsLockedException(propertyChangeEvent);
        }
        this.cpa = string;
        this.firePropertyChange(propertyChangeEvent);
    }

    public final synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.bcd == null) {
            this.bcd = new VetoableChangeSupport(this);
        }
        this.bcd.addVetoableChangeListener(vetoableChangeListener);
    }

    public final void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.bcd == null) {
            return;
        }
        this.bcd.removeVetoableChangeListener(vetoableChangeListener);
    }

    protected final void fireVetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (this.bcd == null) {
            return;
        }
        this.bcd.fireVetoableChange(propertyChangeEvent);
    }

    public final synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.evy == null) {
            this.evy = new PropertyChangeSupport(this);
        }
        this.evy.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.evy == null) {
            return;
        }
        this.evy.removePropertyChangeListener(propertyChangeListener);
    }

    protected final void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.evy == null) {
            return;
        }
        this.evy.firePropertyChange(propertyChangeEvent);
    }
}

