/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.licensing.product;

import codeguard.licensing.qeu;
import java.util.prefs.Preferences;
import org.sonatype.licensing.CustomLicenseContent;
import org.sonatype.licensing.LicensingException;
import org.sonatype.licensing.ProductDetails;
import org.sonatype.licensing.internal.DefaultKeyStoreParam;
import org.sonatype.licensing.product.LicenseBuilder;
import org.sonatype.licensing.trial.TrialLicenseParam;
import org.sonatype.licensing.trial.TrialParam;
import org.sonatype.licensing.util.LicensingUtil;

public abstract class AbstractLicenseBuilder
implements LicenseBuilder {
    private static final String ymv = new qeu(new long[]{-1690058102093644793L, 3975167369736229458L, 6881864084162147984L}).toString();
    private static final String bzn = new qeu(new long[]{348214743486407250L, -5665724013535777408L, 5783893877095155298L, -9222320762758361454L, 6192500194308087316L, 3477852850060463659L, 7694194449945358034L, -362616691434936395L, -8857163466429480282L}).toString();
    private final ProductDetails sqr;
    private final TrialParam aab;
    private final String fvf;

    public AbstractLicenseBuilder(ProductDetails productDetails, TrialParam trialParam, String string) {
        this.sqr = productDetails;
        this.aab = trialParam == null ? new itm() : trialParam;
        this.fvf = string == null ? LicensingUtil.getPackage(productDetails.getProductName()) : string;
    }

    public AbstractLicenseBuilder(ProductDetails productDetails, TrialParam trialParam) {
        this(productDetails, trialParam, null);
    }

    public AbstractLicenseBuilder(ProductDetails productDetails) {
        this(productDetails, null, null);
    }

    public AbstractLicenseBuilder(ProductDetails productDetails, String string) {
        this(productDetails, null, string);
        if (this.getClass().getResource(this.getPublicKeyStorePath()) == null) {
            throw new IllegalArgumentException("Could not find public key store resource");
        }
        if (this.getClass().getResource(this.getTrialKeyStorePath()) == null) {
            throw new IllegalArgumentException("Could not find trial key store resource");
        }
    }

    @Override
    public TrialLicenseParam buildPublicParam() throws LicensingException {
        DefaultKeyStoreParam defaultKeyStoreParam = new DefaultKeyStoreParam(this.getClass(), this.getPublicKeyStorePath(), this.getPublicKeyStoreAlias(), this.getPublicKeyStorePassword(), null);
        DefaultKeyStoreParam defaultKeyStoreParam2 = new DefaultKeyStoreParam(this.getClass(), this.getTrialKeyStorePath(), this.getTrialKeyStoreAlias(), this.getTrialKeyStorePassword(), this.getTrialKeyStorePassword());
        return new TrialLicenseParam(this.sqr.getProductName(), Preferences.userRoot().node(this.fvf), defaultKeyStoreParam, defaultKeyStoreParam2, this.aab);
    }

    @Override
    public String getPreferenceNodePath() {
        return this.fvf;
    }

    @Override
    public String getPublicKeyStoreAlias() {
        return this.sqr.getProductName();
    }

    @Override
    public String getTrialKeyStorePassword() {
        return ymv;
    }

    @Override
    public String getTrialKeyStoreAlias() {
        return ymv;
    }

    @Override
    public String getTrialKeyStorePath() {
        return bzn;
    }

    static class itm
    implements TrialParam {
        private itm() {
        }

        @Override
        public boolean isEligibleForTrial() {
            return false;
        }

        @Override
        public void removeTrialEligibility() {
        }

        @Override
        public int getDaysForTrial() {
            return 1;
        }

        @Override
        public CustomLicenseContent createTrialLicenseContent() {
            throw new UnsupportedOperationException("This trial parameter is never eligible for trial licensing.");
        }

        @Override
        public void trialGranted(CustomLicenseContent customLicenseContent) {
            throw new UnsupportedOperationException("This trial parameter is never eligible for trial licensing.");
        }
    }
}

