/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.licensing.product.access.internal;

import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.licensing.product.access.AccessEntry;
import org.sonatype.licensing.product.access.AccessEntrySet;
import org.sonatype.licensing.product.access.AccessManager;
import org.sonatype.licensing.product.access.io.AccessPersistence;

@Singleton
@Named(value="licensing.default")
public class DefaultAccessManager
implements AccessManager {
    public static final int DEFAULT_MAX_ENTRIES_BETWEEN_SAVE = 100;
    public static final int DEFAULT_MAX_TIME_BETWEEN_SAVE = 300000;
    private int ifu = 100;
    private int wzy = 300000;
    private final Logger ooh = LoggerFactory.getLogger(this.getClass());
    private final AccessPersistence tlx;
    private AccessEntrySet uzp = new AccessEntrySet();
    private final ConcurrentLinkedQueue<AccessEntry> zai;
    private final itm xas = new itm();
    private Future<?> uca;

    @Inject
    public DefaultAccessManager(AccessPersistence accessPersistence) throws IOException {
        this.zai = new ConcurrentLinkedQueue();
        this.tlx = accessPersistence;
        this.uzp = accessPersistence.load();
        Thread thread = new Thread(this.xas);
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public boolean add(AccessEntry accessEntry) {
        this.ooh.trace("Adding access entry: {}", (Object)accessEntry);
        return this.zai.add(accessEntry);
    }

    @Override
    public synchronized Set<AccessEntry> getSince(Date date) {
        long l = date.getTime();
        HashSet<AccessEntry> hashSet = new HashSet<AccessEntry>();
        for (AccessEntry accessEntry : this.uzp) {
            if (accessEntry.getDate().getTime() <= l) continue;
            hashSet.add(accessEntry);
        }
        return hashSet;
    }

    @Override
    public Set<AccessEntry> expire(Date date) {
        Set<AccessEntry> set = this.getSince(date);
        this.ooh.debug(String.format("expiring access entries: %s from %s", set.size(), this.uzp.size()));
        this.uzp.retainAll(set);
        return set;
    }

    @Override
    public void save() throws IOException {
        this.tlx.save(this.uzp);
    }

    public void purge() {
        this.uzp.clear();
    }

    public boolean hasItemsToBeProcessed() {
        return this.zai.size() != 0;
    }

    public synchronized void shutdown() throws IOException {
        this.ooh.debug("Shutdown");
        try {
            this.xas.shutdown();
        }
        catch (Exception exception) {
            this.ooh.warn("Failure when shutting down queue processor", (Throwable)exception);
        }
        this.xas.ysn();
        this.save();
        this.uzp = null;
    }

    public int getMaxEntriesBetweenSave() {
        return this.ifu;
    }

    public void setMaxEntriesBetweenSave(int n) {
        this.ifu = n;
    }

    public int getMaxTimeBetweenSave() {
        return this.wzy;
    }

    public void setMaxTimeBetweenSave(int n) {
        this.wzy = n;
    }

    class itm
    implements Runnable {
        private boolean running = true;
        private int counter = 0;
        private long rfk = System.currentTimeMillis();
        private Object lock = new Object();

        private itm() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown() throws InterruptedException {
            this.running = false;
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait(2000L);
            }
        }

        private void klp() {
            boolean bl = false;
            if (this.counter >= DefaultAccessManager.this.ifu) {
                DefaultAccessManager.this.ooh.trace("Entry count reached save threshold");
                bl = true;
            } else if (this.counter > 0 && System.currentTimeMillis() - this.rfk >= (long)DefaultAccessManager.this.wzy) {
                DefaultAccessManager.this.ooh.trace("Time elapsed since last save exceeded");
                bl = true;
            }
            if (bl) {
                try {
                    DefaultAccessManager.this.save();
                    this.counter = 0;
                    this.rfk = System.currentTimeMillis();
                }
                catch (IOException iOException) {
                    DefaultAccessManager.this.ooh.error("Failed to save", (Throwable)iOException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                this.ysn();
                this.klp();
                if (!this.running) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        private void ysn() {
            while (!DefaultAccessManager.this.zai.isEmpty()) {
                DefaultAccessManager.this.uzp.add((AccessEntry)DefaultAccessManager.this.zai.remove());
                ++this.counter;
                DefaultAccessManager.this.ooh.trace("Processed {} entries since last save.", (Object)this.counter);
            }
        }
    }
}

