/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.licensing.product.internal;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.licensing.LicensingException;
import org.sonatype.licensing.feature.Feature;
import org.sonatype.licensing.feature.FeatureValidator;
import org.sonatype.licensing.feature.LicenseFeatureVerifier;
import org.sonatype.licensing.product.ProductLicenseKey;

@Named(value="licensing.default")
@Singleton
public class DefaultLicenseFeatureVerifier
implements LicenseFeatureVerifier {
    private final Logger wab = LoggerFactory.getLogger(this.getClass());
    private final FeatureValidator xgj;
    private final ReadWriteLock fjz = new ReentrantReadWriteLock();
    private ProductLicenseKey svd;
    private boolean valid;

    @Inject
    public DefaultLicenseFeatureVerifier(FeatureValidator featureValidator) {
        this.xgj = featureValidator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verifyLicenseAndFeature(Feature feature) throws LicensingException {
        Lock lock = this.fjz.readLock();
        lock.lock();
        try {
            if (this.wab.isTraceEnabled()) {
                this.wab.trace("Verify (throws) {}", (Object)feature.getId());
                this.wab.trace("Current state: key={}, valid={}", (Object)this.svd, (Object)this.valid);
            }
            if (!this.valid) {
                throw new LicensingException(this.svd, "License is not valid.", null);
            }
            this.xgj.validate(feature, this.svd);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(Feature feature) {
        Lock lock = this.fjz.readLock();
        lock.lock();
        try {
            if (this.wab.isTraceEnabled()) {
                this.wab.trace("Verify (boolean) {}", (Object)feature.getId());
                this.wab.trace("Current state: key={}, valid={}", (Object)this.svd, (Object)this.valid);
            }
            boolean bl = this.valid && this.xgj.isValid(feature, this.svd);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @VisibleForTesting
    ProductLicenseKey zhj() {
        return this.svd;
    }

    @VisibleForTesting
    boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void updateState(ProductLicenseKey productLicenseKey, boolean bl) {
        Lock lock = this.fjz.writeLock();
        lock.lock();
        try {
            this.wab.debug("Update state: key={}, valid={}", (Object)productLicenseKey, (Object)bl);
            this.svd = productLicenseKey;
            this.valid = bl;
        }
        finally {
            lock.unlock();
        }
    }
}

