/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.licensing.product.internal;

import codeguard.licensing.agq;
import codeguard.licensing.aua;
import codeguard.licensing.bjw;
import codeguard.licensing.bos;
import codeguard.licensing.haa;
import codeguard.licensing.omz;
import codeguard.licensing.whz;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.licensing.ProductDetails;
import org.sonatype.licensing.feature.Feature;
import org.sonatype.licensing.product.SslKeyContainer;
import org.sonatype.licensing.product.internal.ProductLicenseKeyRequest;
import org.sonatype.licensing.util.LicensingUtil;

@Named(value="licensing.default")
public class DefaultLicenseKeyRequest
extends bos
implements ProductLicenseKeyRequest {
    private final Logger ooh = LoggerFactory.getLogger(DefaultLicenseKeyRequest.class);
    private static final String ISSUER_NAME = LicensingUtil.unobfuscate(new long[]{-1075740369556149950L, 6473667505195108430L});
    private static final String erd = LicensingUtil.unobfuscate(new long[]{5431597888647840358L, -3003659393323666576L});
    private static final String fnf = LicensingUtil.unobfuscate(new long[]{-2011739764646339905L, 1056792054092558862L});
    private boolean iui;
    private int tjb = -1;
    private SslKeyContainer[] xbq = new SslKeyContainer[0];
    private final ProductDetails sqr;
    private Collection<String> uqq = Collections.emptySet();
    private Properties lak = new Properties();

    @Inject
    public DefaultLicenseKeyRequest(ProductDetails productDetails) {
        super(productDetails);
        this.sqr = productDetails;
    }

    @Override
    public boolean isFreeLicense() {
        return this.iui;
    }

    @Override
    public void setFreeLicense(boolean bl) {
        this.iui = bl;
    }

    @Override
    public int getLicensedUsers() {
        return this.tjb;
    }

    @Override
    public void setLicensedUsers(int n) {
        this.tjb = n;
    }

    @Override
    public X500Principal getIssuer() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CN=").append(ISSUER_NAME).append(", ");
        stringBuilder.append("OU=").append(this.sqr.getBrandName()).append(", ");
        stringBuilder.append("O=").append(this.sqr.getBrandName()).append(", ");
        stringBuilder.append("L=").append(erd).append(", ");
        stringBuilder.append("C=").append(fnf);
        return new X500Principal(stringBuilder.toString());
    }

    @Override
    public String getExtraContent() {
        Object object2;
        agq agq2 = new agq();
        agq2.setVersion("1.0.2");
        agq2.setEvaluation(this.isEvaluation());
        agq2.setFreeLicense(this.isFreeLicense());
        agq2.setLicensedUsers(this.getLicensedUsers());
        for (String object22 : this.getLicensedProducts()) {
            object2 = new bjw();
            ((bjw)object2).setId(object22);
            agq2.itm((bjw)object2);
        }
        for (Feature feature : this.getFeatureSet()) {
            object2 = new whz();
            ((whz)object2).setId(feature.getId());
            agq2.itm((whz)object2);
        }
        for (SslKeyContainer sslKeyContainer : this.getKeys()) {
            object2 = new haa();
            ((haa)object2).setEntry(sslKeyContainer.getEntry());
            ((haa)object2).setPassword(sslKeyContainer.getPassword());
            ((haa)object2).setType(sslKeyContainer.getType().toString());
            agq2.itm((haa)object2);
        }
        Properties properties = this.getProperties();
        for (Object object2 : properties.keySet()) {
            String string = (String)object2;
            aua aua2 = new aua();
            aua2.eui(string);
            aua2.setValue(properties.getProperty(string));
            agq2.itm(aua2);
        }
        StringWriter stringWriter = new StringWriter();
        object2 = new omz();
        try {
            ((omz)object2).itm(stringWriter, agq2);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            this.ooh.error("Unable to store license content properly", (Throwable)iOException);
            return null;
        }
    }

    @Override
    public List<SslKeyContainer> getKeys() {
        return Arrays.asList(this.xbq);
    }

    @Override
    public void setKeys(SslKeyContainer[] sslKeyContainerArray) {
        this.xbq = sslKeyContainerArray;
    }

    @Override
    public void setLicensedProducts(Collection<String> collection) {
        this.uqq = collection;
    }

    @Override
    public Collection<String> getLicensedProducts() {
        return this.uqq;
    }

    @Override
    public Properties getProperties() {
        return this.lak;
    }

    @Override
    public void setProperties(Properties properties) {
        this.lak = properties;
    }
}

