/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.licensing.product.internal;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import org.codehaus.plexus.util.Base64;
import org.sonatype.licensing.product.SslKeyContainer;

public class GenericSslKeyContainer
implements SslKeyContainer {
    private String ajv;
    private String password;
    private SslKeyContainer.Type krh;

    public GenericSslKeyContainer(String string, String string2, SslKeyContainer.Type type) {
        this.ajv = string;
        this.password = string2;
        this.krh = type;
    }

    public GenericSslKeyContainer(File file, String string, SslKeyContainer.Type type) throws IOException {
        this(GenericSslKeyContainer.eui(file), string, type);
    }

    protected static String b64encode(byte[] byArray) throws UnsupportedEncodingException {
        byte[] byArray2 = Base64.encodeBase64((byte[])byArray);
        return new String(byArray2, "US-ASCII");
    }

    private static String eui(File file) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            byte[] byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(byArray);
            String string = GenericSslKeyContainer.b64encode(byArray);
            return string;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot base64encode file: " + iOException.toString(), iOException);
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    @Override
    public String getEntry() {
        return this.ajv;
    }

    public void setEntry(String string) {
        this.ajv = string;
    }

    @Override
    public SslKeyContainer.Type getType() {
        return this.krh;
    }

    public void setType(SslKeyContainer.Type type) {
        this.krh = type;
    }
}

