/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.licensing.product.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.licensing.product.LicenseChangeListener;
import org.sonatype.licensing.product.LicenseChangeNotifier;
import org.sonatype.licensing.product.ProductLicenseKey;
import org.sonatype.licensing.product.internal.DefaultLicenseFeatureVerifier;
import org.sonatype.licensing.product.util.LicenseFingerprintStrategy;

@Named(value="licensing.default")
@Singleton
public class LicenseChangeNotifierImpl
implements LicenseChangeNotifier {
    private final Logger wab = LoggerFactory.getLogger(this.getClass());
    private final List<LicenseChangeListener> listeners;
    private final DefaultLicenseFeatureVerifier onp;
    private final LicenseFingerprintStrategy rbr;
    private final Map<LicenseChangeListener, AtomicReference<itm>> bsv = new WeakHashMap<LicenseChangeListener, AtomicReference<itm>>();

    @Inject
    public LicenseChangeNotifierImpl(List<LicenseChangeListener> list, DefaultLicenseFeatureVerifier defaultLicenseFeatureVerifier, LicenseFingerprintStrategy licenseFingerprintStrategy) {
        this.onp = (DefaultLicenseFeatureVerifier)Preconditions.checkNotNull((Object)defaultLicenseFeatureVerifier);
        this.listeners = (List)Preconditions.checkNotNull(list);
        this.rbr = (LicenseFingerprintStrategy)Preconditions.checkNotNull((Object)licenseFingerprintStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyListeners(ProductLicenseKey productLicenseKey, boolean bl, Exception exception) {
        if (exception != null) {
            this.wab.debug("License invalid", (Throwable)exception);
        } else {
            this.wab.debug("License {}", (Object)(bl ? "valid" : "invalid"));
        }
        this.onp.updateState(productLicenseKey, bl);
        String string = productLicenseKey != null ? this.rbr.calculate(productLicenseKey) : null;
        for (LicenseChangeListener licenseChangeListener : this.listeners) {
            AtomicReference<itm> atomicReference;
            Object object = this.bsv;
            synchronized (object) {
                atomicReference = this.bsv.get(licenseChangeListener);
                if (atomicReference == null) {
                    atomicReference = new AtomicReference<Object>(null);
                    this.bsv.put(licenseChangeListener, atomicReference);
                }
            }
            object = new itm(string, bl);
            if (!((itm)object).equals(atomicReference.getAndSet((itm)object))) {
                this.wab.trace("Notifying listener: {}", (Object)licenseChangeListener);
                try {
                    licenseChangeListener.licenseChanged(productLicenseKey, bl);
                }
                catch (Exception exception2) {
                    this.wab.trace("Failed to notify listener", (Throwable)exception2);
                }
                continue;
            }
            this.wab.trace("Skipping listener notification; state has not changed: {}", (Object)licenseChangeListener);
        }
    }

    static class itm {
        final String wie;
        final boolean valid;

        private itm(String string, boolean bl) {
            this.wie = string;
            this.valid = bl;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            itm itm2 = (itm)object;
            if (this.valid != itm2.valid) {
                return false;
            }
            return !(this.wie != null ? !this.wie.equals(itm2.wie) : itm2.wie != null);
        }

        public int hashCode() {
            return this.wie != null ? this.wie.hashCode() : 0;
        }
    }
}

