/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.licensing.product.internal;

import codeguard.licensing.dvh;
import com.google.common.base.Preconditions;
import com.google.inject.Key;
import java.util.Timer;
import java.util.TimerTask;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.BeanLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.licensing.LicensingException;
import org.sonatype.licensing.product.LicenseChangeListener;
import org.sonatype.licensing.product.LicenseChangeNotifier;
import org.sonatype.licensing.product.PeriodicLicenseValidator;
import org.sonatype.licensing.product.ProductLicenseKey;
import org.sonatype.licensing.product.ProductLicenseManager;

@Named(value="licensing.default")
@Singleton
public class PeriodicLicenseValidatorImpl
implements PeriodicLicenseValidator {
    private static final String wmd = "${org.sonatype.licensing.product.internal.PeriodicLicenseValidatorImpl";
    private static final long rvm = 300000L;
    private final Logger wab = LoggerFactory.getLogger(this.getClass());
    private final ProductLicenseManager cfw;
    private final LicenseChangeNotifier pqu;
    private final long period;
    private Timer eel;
    private TimerTask xxd;
    private boolean started;

    @Inject
    public PeriodicLicenseValidatorImpl(ProductLicenseManager productLicenseManager, LicenseChangeNotifier licenseChangeNotifier, BeanLocator beanLocator, @Named(value="${org.sonatype.licensing.product.internal.PeriodicLicenseValidatorImpl.period:-300000}") long l) {
        this.cfw = (ProductLicenseManager)Preconditions.checkNotNull((Object)productLicenseManager);
        this.pqu = (LicenseChangeNotifier)Preconditions.checkNotNull((Object)licenseChangeNotifier);
        this.period = l;
        this.wab.debug("Period: {}", (Object)l);
        beanLocator.watch(Key.get(LicenseChangeListener.class), (Mediator)new itm(), (Object)this);
    }

    @Override
    public synchronized void start() {
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"Already started");
        this.wab.debug("Starting");
        this.xxd = new dvh(this);
        this.eel = new Timer(this.getClass().getSimpleName() + "-timer", true);
        this.eel.schedule(this.xxd, 0L, this.period);
        this.started = true;
    }

    @Override
    public synchronized void stop() {
        Preconditions.checkState((boolean)this.started, (Object)"Not started");
        this.wab.debug("Stopping");
        if (this.xxd != null) {
            this.xxd.cancel();
            this.xxd = null;
        }
        if (this.eel != null) {
            this.eel.purge();
            this.eel.cancel();
            this.eel = null;
        }
        this.started = false;
    }

    @Override
    public synchronized boolean isRunning() {
        return this.started;
    }

    private void validate() {
        this.wab.debug("Validating");
        try {
            ProductLicenseKey productLicenseKey = this.cfw.getLicenseDetails();
            assert (productLicenseKey != null);
            this.notifyListeners(productLicenseKey, true, null);
        }
        catch (LicensingException licensingException) {
            this.notifyListeners((ProductLicenseKey)licensingException.getKey(), false, licensingException);
        }
        catch (Exception exception) {
            this.wab.error("Failed to get license details", (Throwable)exception);
        }
    }

    private void notifyListeners(ProductLicenseKey productLicenseKey, boolean bl, Exception exception) {
        try {
            this.pqu.notifyListeners(productLicenseKey, bl, exception);
        }
        catch (Exception exception2) {
            if (exception != null) {
                this.wab.error("Failed to notify listeners about key='{}', valid={}, failure={}/{}", new Object[]{productLicenseKey, bl, exception.getClass().getName(), exception.getMessage(), exception2});
            }
            this.wab.error("Failed to notify listeners about key='{}', valid={}", new Object[]{productLicenseKey, bl, exception2});
        }
    }

    static final class itm
    implements Mediator<Named, LicenseChangeListener, PeriodicLicenseValidatorImpl> {
        itm() {
        }

        public void itm(BeanEntry<Named, LicenseChangeListener> beanEntry, PeriodicLicenseValidatorImpl periodicLicenseValidatorImpl) {
            if (periodicLicenseValidatorImpl.started) {
                periodicLicenseValidatorImpl.validate();
            }
        }

        public void omj(BeanEntry<Named, LicenseChangeListener> beanEntry, PeriodicLicenseValidatorImpl periodicLicenseValidatorImpl) {
        }

        public /* synthetic */ void remove(BeanEntry beanEntry, Object object) throws Exception {
            this.omj((BeanEntry<Named, LicenseChangeListener>)beanEntry, (PeriodicLicenseValidatorImpl)object);
        }

        public /* synthetic */ void add(BeanEntry beanEntry, Object object) throws Exception {
            this.itm((BeanEntry<Named, LicenseChangeListener>)beanEntry, (PeriodicLicenseValidatorImpl)object);
        }
    }
}

