/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.licensing.product.util;

import java.util.prefs.Preferences;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.codec.binary.Base64;
import org.sonatype.licensing.LicenseKey;
import org.sonatype.licensing.LicensingException;
import org.sonatype.licensing.product.LicenseBuilder;
import org.sonatype.licensing.product.ProductLicenseKey;
import org.sonatype.licensing.product.ProductLicenseManager;

@Named
@Singleton
public class LicenseContent {
    private final ProductLicenseManager cfw;
    private final String ztm;

    @Inject
    public LicenseContent(LicenseBuilder licenseBuilder, ProductLicenseManager productLicenseManager) {
        this.cfw = productLicenseManager;
        this.ztm = licenseBuilder.getPreferenceNodePath();
    }

    public byte[] raw() {
        return Base64.decodeBase64((String)Preferences.userRoot().node(this.ztm).get("license", null));
    }

    public ProductLicenseKey key() {
        try {
            return this.cfw.getLicenseDetails();
        }
        catch (LicensingException licensingException) {
            LicenseKey licenseKey = licensingException.getKey();
            if (!(licenseKey instanceof ProductLicenseKey)) {
                return null;
            }
            return (ProductLicenseKey)licenseKey;
        }
    }
}

