/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.licensing.product.util;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.licensing.product.ProductLicenseKey;
import org.sonatype.licensing.product.util.LicenseContent;
import org.sonatype.licensing.product.util.LicenseFingerprintStrategy;
import org.sonatype.licensing.product.util.LicenseFingerprintStrategyImpl;

@Named
@Singleton
public class LicenseFingerprinter {
    private final LicenseFingerprintStrategy ugf;
    private final LicenseContent utz;

    public LicenseFingerprinter() {
        this.utz = null;
        this.ugf = new LicenseFingerprintStrategyImpl();
    }

    @Inject
    public LicenseFingerprinter(LicenseFingerprintStrategy licenseFingerprintStrategy, @Nullable LicenseContent licenseContent) {
        this.ugf = (LicenseFingerprintStrategy)Preconditions.checkNotNull((Object)licenseFingerprintStrategy);
        this.utz = licenseContent;
    }

    public String calculate() {
        if (this.utz == null) {
            throw new IllegalStateException("No license content available.");
        }
        return this.calculate(this.utz.key());
    }

    public String calculate(ProductLicenseKey productLicenseKey) {
        return this.ugf.calculate(productLicenseKey);
    }
}

