/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.model;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ReverseLookupTable
implements Serializable {
    private static final long serialVersionUID = 3981431227660901699L;
    private Properties anonymizations = new Properties();
    private Properties fileHashes = new Properties();
    private List<File> files = new ArrayList<File>();
    private transient Map<Object, Object> work = new HashMap<Object, Object>();

    public boolean isEmpty() {
        return this.anonymizations.isEmpty() && this.fileHashes.isEmpty() && this.files.isEmpty();
    }

    public String lookupAnonymization(String anon) {
        return this.anonymizations.getProperty(anon);
    }

    public Collection<String> getAnonymizations() {
        return this.anonymizations.keySet();
    }

    public void addAnonymization(String anon, String value) {
        this.anonymizations.setProperty(anon, value);
    }

    public String[] lookupFileHashes(String hash) {
        String s = this.fileHashes.getProperty(hash);
        if (s != null) {
            return s.split("\\|");
        }
        return new String[0];
    }

    public Collection<String> getFileHashes() {
        return this.fileHashes.keySet();
    }

    public void addFileHash(String hash, String path) {
        String val = this.fileHashes.getProperty(hash);
        if (val != null) {
            this.fileHashes.setProperty(hash, val + "|" + path);
        } else {
            this.fileHashes.setProperty(hash, path);
        }
    }

    public void addFile(File file) {
        this.files.add(file);
    }

    public Collection<File> getFiles() {
        return this.files;
    }

    public <T> T getWorkData(Object key, Class<T> type) {
        Object value = this.work.get(key);
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        return null;
    }

    public void setWorkData(Object key, Object value) {
        if (value == null) {
            this.work.remove(key);
        } else {
            this.work.put(key, value);
        }
    }
}

