/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.transaction;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import org.aopalliance.intercept.Joinpoint;
import org.sonatype.nexus.transaction.Operation;
import org.sonatype.nexus.transaction.VoidOperation;

final class OperationPoint<T, E extends Exception>
implements Joinpoint {
    private final Operation<T, E> proceed;
    private final Object self;
    private final Supplier<Method> staticPart;

    OperationPoint(Operation<T, E> operation) {
        this.proceed = operation;
        this.self = operation;
        this.staticPart = OperationPoint.lazyMethod(operation, "call");
    }

    OperationPoint(VoidOperation<E> operation) {
        this.proceed = () -> {
            operation.run();
            return null;
        };
        this.self = operation;
        this.staticPart = OperationPoint.lazyMethod(operation, "run");
    }

    public T proceed() throws E {
        return this.proceed.call();
    }

    public final Object getThis() {
        return this.self;
    }

    public final AccessibleObject getStaticPart() {
        return (AccessibleObject)this.staticPart.get();
    }

    public String toString() {
        return this.self.toString();
    }

    private static Supplier<Method> lazyMethod(Object instance, String method) {
        return Suppliers.memoize(() -> {
            try {
                return instance.getClass().getMethod(method, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new LinkageError("Missing '" + method + "' method", e);
            }
        });
    }
}

