/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.transaction;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import java.lang.annotation.Annotation;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.transaction.Operation;
import org.sonatype.nexus.transaction.OperationPoint;
import org.sonatype.nexus.transaction.Transaction;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.TransactionalImpl;
import org.sonatype.nexus.transaction.TransactionalWrapper;
import org.sonatype.nexus.transaction.UnitOfWork;
import org.sonatype.nexus.transaction.VoidOperation;

public class Operations<E extends Exception, B extends Operations<E, B>> {
    private static final Logger log = LoggerFactory.getLogger(Operations.class);
    private static final Class<?>[] NOTHING = new Class[0];
    @VisibleForTesting
    static final Transactional DEFAULT_SPEC = new TransactionalImpl(NOTHING, NOTHING, NOTHING);
    @VisibleForTesting
    final Transactional spec;
    @Nullable
    private final Class<E> throwing;
    @Nullable
    private final Supplier<? extends Transaction> db;

    @SafeVarargs
    public final B commitOn(Class<? extends Exception> ... exceptionTypes) {
        Class[] commitOn = (Class[])Operations.deepCheckNotNull(exceptionTypes).clone();
        return (B)this.copy(new TransactionalImpl(commitOn, this.spec.retryOn(), this.spec.swallow()), this.throwing, this.db);
    }

    @SafeVarargs
    public final B retryOn(Class<? extends Exception> ... exceptionTypes) {
        Class[] retryOn = (Class[])Operations.deepCheckNotNull(exceptionTypes).clone();
        return (B)this.copy(new TransactionalImpl(this.spec.commitOn(), retryOn, this.spec.swallow()), this.throwing, this.db);
    }

    @SafeVarargs
    public final B swallow(Class<? extends Exception> ... exceptionTypes) {
        Class[] swallow = (Class[])Operations.deepCheckNotNull(exceptionTypes).clone();
        return (B)this.copy(new TransactionalImpl(this.spec.commitOn(), this.spec.retryOn(), swallow), this.throwing, this.db);
    }

    public final B stereotype(Class<? extends Annotation> annotationType) {
        Transactional metaSpec = annotationType.getAnnotation(Transactional.class);
        Preconditions.checkArgument((metaSpec != null ? 1 : 0) != 0, (Object)"Stereotype annotation is not meta-annotated with @Transactional");
        return (B)this.copy(metaSpec, this.throwing, this.db);
    }

    public <X extends Exception> Operations<X, ?> throwing(Class<X> exceptionType) {
        return this.copy(this.spec, (Class)Preconditions.checkNotNull(exceptionType), this.db);
    }

    public final B withDb(Supplier<? extends Transaction> txSupplier) {
        return (B)this.copy(this.spec, this.throwing, (Supplier<Transaction>)((Supplier)Preconditions.checkNotNull(txSupplier)));
    }

    public final <T> T call(Operation<T, E> operation) throws E {
        return this.transactional(new OperationPoint<T, E>(operation));
    }

    public final void run(VoidOperation<E> operation) throws E {
        this.transactional(new OperationPoint(operation));
    }

    protected Operations() {
        this(DEFAULT_SPEC, null, null);
    }

    protected Operations(Transactional spec, @Nullable Class<E> throwing, @Nullable Supplier<? extends Transaction> db) {
        this.spec = (Transactional)Preconditions.checkNotNull((Object)spec);
        this.throwing = throwing;
        this.db = db;
    }

    protected <X extends Exception> Operations<X, ?> copy(Transactional spec, @Nullable Class<X> throwing, @Nullable Supplier<? extends Transaction> db) {
        return new Operations<X, B>(spec, throwing, db);
    }

    private <T> T transactional(OperationPoint<T, E> point) throws E {
        log.trace("Invoking: {} -> {}", (Object)this.spec, point);
        UnitOfWork work = UnitOfWork.createWork();
        if (work.isActive()) {
            return point.proceed();
        }
        try {
            Object object;
            block17: {
                Throwable throwable = null;
                Object var4_6 = null;
                Transaction tx = work.acquireTransaction(this.db);
                try {
                    object = new TransactionalWrapper(this.spec, point).proceedWithTransaction(tx);
                    if (tx == null) break block17;
                }
                catch (Throwable throwable2) {
                    try {
                        if (tx != null) {
                            tx.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        try {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                        catch (Throwable e) {
                            if (this.throwing != null) {
                                Throwables.propagateIfPossible((Throwable)e, this.throwing);
                            }
                            Throwables.throwIfUnchecked((Throwable)e);
                            throw new RuntimeException(e);
                        }
                    }
                }
                tx.close();
            }
            work.releaseTransaction();
            return (T)object;
        }
        catch (Throwable throwable) {
            work.releaseTransaction();
            throw throwable;
        }
    }

    private static <T> T[] deepCheckNotNull(T[] elements) {
        T[] TArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            T e = TArray[n2];
            Preconditions.checkNotNull(e);
            ++n2;
        }
        return elements;
    }
}

