/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.transaction;

import com.google.common.base.Supplier;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.Joinpoint;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.transaction.Transaction;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.TransactionalAware;
import org.sonatype.nexus.transaction.TransactionalWrapper;
import org.sonatype.nexus.transaction.UnitOfWork;

final class TransactionInterceptor
extends ComponentSupport
implements MethodInterceptor {
    TransactionInterceptor() {
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        Method method = mi.getMethod();
        Transactional spec = TransactionInterceptor.findSpec(method);
        this.log.trace("Invoking: {} -> {}", (Object)spec, (Object)method);
        UnitOfWork work = UnitOfWork.createWork();
        if (work.isActive()) {
            return mi.proceed();
        }
        Supplier<? extends Transaction> txSupplier = null;
        if (mi.getThis() instanceof TransactionalAware) {
            txSupplier = ((TransactionalAware)mi.getThis()).txSupplier();
        }
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (Transaction tx = work.acquireTransaction(txSupplier);){
                Object object = new TransactionalWrapper(spec, (Joinpoint)mi).proceedWithTransaction(tx);
                work.releaseTransaction();
                return object;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            work.releaseTransaction();
            throw throwable;
        }
    }

    private static final Transactional findSpec(Method method) {
        Transactional spec = method.getAnnotation(Transactional.class);
        if (spec != null) {
            return spec;
        }
        Annotation[] annotationArray = method.getDeclaredAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation ann = annotationArray[n2];
            spec = ann.annotationType().getAnnotation(Transactional.class);
            if (spec != null) {
                return spec;
            }
            ++n2;
        }
        throw new IllegalStateException("Missing @Transactional on: " + method);
    }
}

