/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.transaction;

import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.sonatype.nexus.common.guice.AbstractInterceptorModule;
import org.sonatype.nexus.transaction.TransactionInterceptor;
import org.sonatype.nexus.transaction.Transactional;

public class TransactionModule
extends AbstractInterceptorModule {
    protected void configure() {
        this.bindInterceptor(Matchers.any(), (Matcher)new TransactionalMatcher(), new MethodInterceptor[]{new TransactionInterceptor()});
    }

    private static final class TransactionalMatcher
    extends AbstractMatcher<Method> {
        private TransactionalMatcher() {
        }

        public boolean matches(Method method) {
            if (method.isAnnotationPresent(Transactional.class)) {
                return true;
            }
            Annotation[] annotationArray = method.getDeclaredAnnotations();
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation ann = annotationArray[n2];
                if (ann.annotationType().isAnnotationPresent(Transactional.class)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

