/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.transaction;

import org.aopalliance.intercept.Joinpoint;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Loggers;
import org.sonatype.nexus.transaction.Transaction;
import org.sonatype.nexus.transaction.Transactional;

final class TransactionalWrapper {
    private static final Logger log = Loggers.getLogger(TransactionalWrapper.class);
    private final Transactional spec;
    private final Joinpoint aspect;
    private final boolean tracing;

    public TransactionalWrapper(Transactional spec, Joinpoint aspect) {
        this.spec = spec;
        this.aspect = aspect;
        this.tracing = log.isTraceEnabled();
    }

    public Object proceedWithTransaction(Transaction tx) throws Throwable {
        while (true) {
            Object object;
            boolean committed = false;
            Throwable throwing = null;
            Object result = null;
            if (this.tracing) {
                log.trace("BEGIN {} : {}", (Object)tx, (Object)this.aspect.getStaticPart());
            }
            tx.begin();
            try {
                object = result = this.aspect.proceed();
            }
            catch (Throwable e) {
                try {
                    try {
                        throwing = e;
                    }
                    catch (Throwable throwable) {
                        if (throwing == null || TransactionalWrapper.instanceOf(throwing, this.spec.commitOn())) {
                            if (this.tracing) {
                                log.trace("COMMIT {} : {}", new Object[]{tx, this.aspect.getStaticPart(), throwing});
                            }
                            tx.commit();
                            committed = true;
                        }
                        if (throwing != null) {
                            throw throwing;
                        }
                        throw throwable;
                    }
                    if (throwing == null || TransactionalWrapper.instanceOf(throwing, this.spec.commitOn())) {
                        if (this.tracing) {
                            log.trace("COMMIT {} : {}", new Object[]{tx, this.aspect.getStaticPart(), throwing});
                        }
                        tx.commit();
                        committed = true;
                    }
                    if (throwing == null) continue;
                    throw throwing;
                }
                catch (Exception e2) {
                    if (!committed) {
                        if (this.tracing) {
                            log.trace("ROLLBACK {} : {}", new Object[]{tx, this.aspect.getStaticPart(), e2});
                        }
                        tx.rollback();
                        if (TransactionalWrapper.instanceOf(e2, this.spec.retryOn()) && tx.allowRetry(e2)) {
                            if (!this.tracing) continue;
                            log.trace("RETRY {} : {}", new Object[]{tx, this.aspect.getStaticPart(), e2});
                            continue;
                        }
                        if (throwing != e2 && TransactionalWrapper.instanceOf(e2, this.spec.swallow())) {
                            if (this.tracing) {
                                log.trace("SWALLOW {} : {}", new Object[]{tx, this.aspect.getStaticPart(), e2});
                            }
                            if (throwing != null) {
                                throw throwing;
                            }
                            return result;
                        }
                    }
                    if (throwing != null && throwing != e2) {
                        e2.addSuppressed(throwing);
                    }
                    throw e2;
                }
            }
            if (throwing == null || TransactionalWrapper.instanceOf(throwing, this.spec.commitOn())) {
                if (this.tracing) {
                    log.trace("COMMIT {} : {}", new Object[]{tx, this.aspect.getStaticPart(), throwing});
                }
                tx.commit();
                committed = true;
            }
            if (throwing != null) {
                throw throwing;
            }
            return object;
            break;
        }
    }

    private static boolean instanceOf(Throwable throwable, Class<?> ... types) {
        Throwable cause = throwable.getCause();
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> t = classArray[n2];
            if (t.isInstance(throwable) || t.isInstance(cause)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

