/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.transaction;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;
import org.sonatype.nexus.transaction.BatchTransaction;
import org.sonatype.nexus.transaction.Transaction;

public final class UnitOfWork {
    private static final ThreadLocal<UnitOfWork> SELF = new ThreadLocal();
    private final Deque<Supplier<? extends Transaction>> dbHistory = new ArrayDeque<Supplier<? extends Transaction>>();
    private Transaction tx;

    private UnitOfWork() {
    }

    public static void begin(Supplier<? extends Transaction> db) {
        Preconditions.checkNotNull(db);
        UnitOfWork.createWork().doBegin(db);
    }

    public static void beginBatch(Supplier<? extends Transaction> db) {
        UnitOfWork.begin((Supplier<? extends Transaction>)Suppliers.compose(tx -> new BatchTransaction((Transaction)tx), db));
    }

    public static void beginBatch(Transaction tx) {
        UnitOfWork.begin((Supplier<? extends Transaction>)Suppliers.ofInstance((Object)new BatchTransaction(tx)));
        UnitOfWork.currentWork().acquireTransaction(null);
    }

    public static <T extends Transaction> T currentTx() {
        Transaction tx = UnitOfWork.currentWork().tx;
        if (tx instanceof BatchTransaction) {
            tx = ((BatchTransaction)tx).delegate;
        }
        Preconditions.checkState((tx != null ? 1 : 0) != 0, (Object)"No transaction for current context");
        return (T)tx;
    }

    public static UnitOfWork pause() {
        UnitOfWork self = SELF.get();
        SELF.remove();
        return self;
    }

    public static void resume(UnitOfWork self) {
        Preconditions.checkState((SELF.get() == null ? 1 : 0) != 0, (Object)"Unit of work is already set");
        SELF.set(self);
    }

    public static void end() {
        UnitOfWork.currentWork().doEnd();
    }

    static UnitOfWork createWork() {
        UnitOfWork self = SELF.get();
        if (self == null) {
            self = new UnitOfWork();
            SELF.set(self);
        }
        return self;
    }

    static UnitOfWork currentWork() {
        UnitOfWork self = SELF.get();
        Preconditions.checkState((self != null ? 1 : 0) != 0, (Object)"Unit of work has not been set");
        return self;
    }

    boolean isActive() {
        return this.tx != null && this.tx.isActive();
    }

    Transaction acquireTransaction(@Nullable Supplier<? extends Transaction> customDb) {
        if (this.tx == null) {
            Supplier<? extends Transaction> db = customDb;
            if (db == null) {
                db = this.dbHistory.peek();
                Preconditions.checkState((db != null ? 1 : 0) != 0, (Object)"Unit of work has not been set");
            }
            this.tx = (Transaction)Preconditions.checkNotNull((Object)((Transaction)db.get()));
        }
        return this.tx;
    }

    void releaseTransaction() {
        if (!(this.tx instanceof BatchTransaction)) {
            this.tx = null;
            if (this.dbHistory.isEmpty()) {
                SELF.remove();
            }
        }
    }

    private void doBegin(Supplier<? extends Transaction> db) {
        Preconditions.checkState((this.tx == null ? 1 : 0) != 0, (Object)"Transaction already in progress");
        this.dbHistory.push(db);
    }

    private void doEnd() {
        Throwable throwing;
        block9: {
            throwing = null;
            if (this.tx instanceof BatchTransaction) {
                Preconditions.checkState((!this.tx.isActive() ? 1 : 0) != 0, (Object)"Transaction still in progress");
                try {
                    try {
                        ((BatchTransaction)this.tx).closeBatch();
                    }
                    catch (Throwable e) {
                        throwing = e;
                        this.tx = null;
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    this.tx = null;
                    throw throwable;
                }
                this.tx = null;
            } else {
                Preconditions.checkState((this.tx == null ? 1 : 0) != 0, (Object)"Transaction still in progress");
            }
        }
        this.dbHistory.pop();
        if (this.dbHistory.isEmpty()) {
            SELF.remove();
        }
        if (throwing != null) {
            Throwables.throwIfUnchecked((Throwable)throwing);
            throw new RuntimeException(throwing);
        }
    }
}

