/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.jmx;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import javax.management.ServiceNotFoundException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.jmx.MBeanAttribute;
import org.sonatype.nexus.jmx.MBeanOperation;
import org.sonatype.nexus.jmx.OperationKey;

public class MBean
extends ComponentSupport
implements DynamicMBean {
    private final MBeanInfo info;
    private final Map<String, MBeanAttribute> attributes;
    private final Map<OperationKey, MBeanOperation> operations;
    private static final Object[] EMPTY_PARAMS = new Object[0];
    private static final String[] EMPTY_SIGNATURE = new String[0];

    public MBean(MBeanInfo info, Collection<MBeanAttribute> attributes, Collection<MBeanOperation> operations) {
        this.info = (MBeanInfo)Preconditions.checkNotNull((Object)info);
        ImmutableMap.Builder attrs = ImmutableMap.builder();
        for (MBeanAttribute attribute : attributes) {
            attrs.put((Object)attribute.getName(), (Object)attribute);
        }
        this.attributes = attrs.build();
        ImmutableMap.Builder ops = ImmutableMap.builder();
        for (MBeanOperation operation : operations) {
            ops.put((Object)operation.getKey(), (Object)operation);
        }
        this.operations = ops.build();
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.info;
    }

    public Collection<MBeanAttribute> getAttributes() {
        return this.attributes.values();
    }

    private MBeanAttribute attribute(String name) throws AttributeNotFoundException {
        Preconditions.checkNotNull((Object)name);
        MBeanAttribute attribute = this.attributes.get(name);
        if (attribute == null) {
            throw new AttributeNotFoundException(name);
        }
        return attribute;
    }

    public Collection<MBeanOperation> getOperations() {
        return this.operations.values();
    }

    private MBeanOperation operation(OperationKey key) throws ServiceNotFoundException {
        Preconditions.checkNotNull((Object)key);
        MBeanOperation operation = this.operations.get(key);
        if (operation == null) {
            throw new ServiceNotFoundException("Missing operation: " + key);
        }
        return operation;
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            return this.attribute(name).getValue();
        }
        catch (Exception e) {
            this.log.warn("Failed to get attribute: {}", (Object)name, (Object)e);
            Throwables.propagateIfPossible((Throwable)e, AttributeNotFoundException.class);
            Throwables.propagateIfPossible((Throwable)e, MBeanException.class);
            Throwables.propagateIfPossible((Throwable)e, ReflectionException.class);
            throw new MBeanException(e);
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            String name = attribute.getName();
            Object value = attribute.getValue();
            this.attribute(name).setValue(value);
        }
        catch (Exception e) {
            this.log.warn("Failed to set attribute: {}", (Object)attribute, (Object)e);
            Throwables.propagateIfPossible((Throwable)e, AttributeNotFoundException.class);
            Throwables.propagateIfPossible((Throwable)e, InvalidAttributeValueException.class);
            Throwables.propagateIfPossible((Throwable)e, MBeanException.class);
            Throwables.propagateIfPossible((Throwable)e, ReflectionException.class);
            throw new MBeanException(e);
        }
    }

    @Override
    public AttributeList getAttributes(@Nullable String[] names) {
        AttributeList result = new AttributeList();
        if (names != null) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                try {
                    Attribute attribute = new Attribute(name, this.getAttribute(name));
                    result.add(attribute);
                }
                catch (Exception e) {
                    this.log.warn("Failed to get attribute: {}", (Object)name, (Object)e);
                }
                ++n2;
            }
        }
        return result;
    }

    @Override
    public AttributeList setAttributes(@Nullable AttributeList attributes) {
        AttributeList result = new AttributeList();
        if (attributes != null) {
            for (Attribute attribute : attributes.asList()) {
                try {
                    this.setAttribute(attribute);
                    result.add(attribute);
                }
                catch (Exception e) {
                    this.log.warn("Failed to set attribute: {}", (Object)attribute.getName(), (Object)e);
                }
            }
        }
        return result;
    }

    @Override
    public Object invoke(String name, @Nullable Object[] params, @Nullable String[] types) throws MBeanException, ReflectionException {
        if (params == null) {
            params = EMPTY_PARAMS;
        }
        if (types == null) {
            types = EMPTY_SIGNATURE;
        }
        OperationKey key = new OperationKey(name, types);
        try {
            return this.operation(key).invoke(params);
        }
        catch (Exception e) {
            this.log.warn("Failed to invoke operation: {}", (Object)key, (Object)e);
            Throwables.propagateIfPossible((Throwable)e, MBeanException.class);
            Throwables.propagateIfPossible((Throwable)e, ReflectionException.class);
            throw new MBeanException(e);
        }
    }
}

