/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.compact.internal;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.api.BlobStoreUsageChecker;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
public class CompactBlobStoreTask
extends TaskSupport
implements Cancelable {
    private final BlobStoreManager blobStoreManager;
    private final BlobStoreUsageChecker blobStoreUsageChecker;

    @Inject
    public CompactBlobStoreTask(BlobStoreManager blobStoreManager, BlobStoreUsageChecker blobStoreUsageChecker) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.blobStoreUsageChecker = (BlobStoreUsageChecker)Preconditions.checkNotNull((Object)blobStoreUsageChecker);
    }

    protected Object execute() throws Exception {
        BlobStore blobStore = this.blobStoreManager.get(this.getBlobStoreField());
        if (blobStore != null) {
            blobStore.compact(this.blobStoreUsageChecker);
        } else {
            this.log.warn("Unable to find blob store: {}", (Object)this.getBlobStoreField());
        }
        return null;
    }

    public String getMessage() {
        return "Compacting " + this.getBlobStoreField() + " blob store";
    }

    private String getBlobStoreField() {
        return this.getConfiguration().getString("blobstoreName");
    }
}

