/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.restore;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.blobstore.restore.RestoreBlobStrategy;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.hash.Hashes;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.transaction.UnitOfWork;

public abstract class BaseRestoreBlobStrategy<T>
extends ComponentSupport
implements RestoreBlobStrategy {
    private NodeAccess nodeAccess;
    private RepositoryManager repositoryManager;
    private BlobStoreManager blobStoreManager;
    private DryRunPrefix dryRunPrefix;

    public BaseRestoreBlobStrategy(NodeAccess nodeAccess, RepositoryManager repositoryManager, BlobStoreManager blobStoreManager, DryRunPrefix dryRunPrefix) {
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.dryRunPrefix = (DryRunPrefix)Preconditions.checkNotNull((Object)dryRunPrefix);
    }

    @Override
    public void restore(Properties properties, Blob blob, String blobStoreName, boolean isDryRun) {
        RestoreBlobData blobData = new RestoreBlobData(blob, properties, blobStoreName, this.repositoryManager);
        Optional storageFacet = blobData.getRepository().optionalFacet(StorageFacet.class);
        T restoreData = this.createRestoreData(blobData);
        if (storageFacet.isPresent() && this.canAttemptRestore(restoreData)) {
            this.doRestore((StorageFacet)storageFacet.get(), blobData, restoreData, isDryRun);
        } else {
            this.log.debug("Skipping asset, blob store: {}, repository: {}, blob name: {}, blob id: {}", new Object[]{blobStoreName, blobData.getRepository().getName(), blobData.getBlobName(), blob.getId()});
        }
    }

    private void doRestore(StorageFacet storageFacet, RestoreBlobData blobData, T restoreData, boolean isDryRun) {
        String logPrefix = isDryRun ? this.dryRunPrefix.get() : "";
        String path = this.getAssetPath(restoreData);
        String blobStoreName = blobData.getBlobStoreName();
        String repoName = blobData.getRepository().getName();
        String blobName = blobData.getBlobName();
        Blob blob = blobData.getBlob();
        UnitOfWork.begin((Supplier)storageFacet.txSupplier());
        try {
            if (this.assetExists(restoreData)) {
                this.log.debug("Skipping as asset already exists, blob store: {}, repository: {}, path: {}, blob name: {}, blob id: {}", new Object[]{blobStoreName, repoName, path, blobName, blob.getId()});
                return;
            }
            try {
                if (!isDryRun) {
                    this.doCreateAssetFromBlob(blobData, restoreData, blob);
                }
                this.log.info("{}Restored asset, blob store: {}, repository: {}, path: {}, blob name: {}, blob id: {}", new Object[]{logPrefix, blobStoreName, repoName, path, blobName, blob.getId()});
            }
            catch (Exception e) {
                this.log.error("Error while restoring asset: blob store: {}, repository: {}, path: {}, blob name: {}, blob id: {}", new Object[]{blobStoreName, repoName, path, blobName, blob.getId(), e});
            }
        }
        finally {
            UnitOfWork.end();
        }
    }

    @TransactionalStoreMetadata
    protected void doCreateAssetFromBlob(RestoreBlobData blobData, T restoreData, Blob blob) throws IOException {
        List<HashAlgorithm> hashTypes = this.getHashAlgorithms();
        AssetBlob assetBlob = new AssetBlob(this.nodeAccess, this.blobStoreManager.get(blobData.getBlobStoreName()), blobStore -> blob, blobData.getProperty("@BlobStore.content-type"), Hashes.hash(hashTypes, (InputStream)blob.getInputStream()), true);
        this.createAssetFromBlob(assetBlob, restoreData);
    }

    @Nonnull
    protected List<HashAlgorithm> getHashAlgorithms() {
        return Lists.newArrayList((Object[])new HashAlgorithm[]{HashAlgorithm.SHA1});
    }

    protected abstract T createRestoreData(RestoreBlobData var1);

    protected abstract boolean canAttemptRestore(@Nonnull T var1);

    protected abstract String getAssetPath(@Nonnull T var1);

    protected abstract boolean assetExists(@Nonnull T var1) throws IOException;

    protected abstract void createAssetFromBlob(@Nonnull AssetBlob var1, @Nonnull T var2) throws IOException;

    @Override
    public void after(boolean updateAssets, Repository repository) {
    }
}

