/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.restore;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.api.BlobStoreUsageChecker;
import org.sonatype.nexus.blobstore.restore.IntegrityCheckStrategy;
import org.sonatype.nexus.blobstore.restore.RestoreBlobStrategy;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.types.GroupType;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
public class RestoreMetadataTask
extends TaskSupport
implements Cancelable {
    private final BlobStoreManager blobStoreManager;
    private final RepositoryManager repositoryManager;
    private final Map<String, RestoreBlobStrategy> restoreBlobStrategies;
    private final Map<String, IntegrityCheckStrategy> integrityCheckStrategies;
    private final BlobStoreUsageChecker blobStoreUsageChecker;
    private final DryRunPrefix dryRunPrefix;
    private final IntegrityCheckStrategy defaultIntegrityCheckStrategy;

    @Inject
    public RestoreMetadataTask(BlobStoreManager blobStoreManager, RepositoryManager repositoryManager, Map<String, RestoreBlobStrategy> restoreBlobStrategies, BlobStoreUsageChecker blobStoreUsageChecker, DryRunPrefix dryRunPrefix, Map<String, IntegrityCheckStrategy> integrityCheckStrategies) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.restoreBlobStrategies = (Map)Preconditions.checkNotNull(restoreBlobStrategies);
        this.blobStoreUsageChecker = (BlobStoreUsageChecker)Preconditions.checkNotNull((Object)blobStoreUsageChecker);
        this.dryRunPrefix = (DryRunPrefix)Preconditions.checkNotNull((Object)dryRunPrefix);
        this.defaultIntegrityCheckStrategy = (IntegrityCheckStrategy)Preconditions.checkNotNull((Object)integrityCheckStrategies.get("default"));
        this.integrityCheckStrategies = (Map)Preconditions.checkNotNull(integrityCheckStrategies);
    }

    public String getMessage() {
        return null;
    }

    protected Void execute() throws Exception {
        String blobStoreId = (String)Preconditions.checkNotNull((Object)this.getConfiguration().getString("blobstoreName"));
        boolean dryRun = this.getConfiguration().getBoolean("dryRun", false);
        boolean restoreBlobs = this.getConfiguration().getBoolean("restoreBlobs", false);
        boolean undeleteBlobs = this.getConfiguration().getBoolean("undeleteBlobs", false);
        boolean integrityCheck = this.getConfiguration().getBoolean("integrityCheck", false);
        this.restore(blobStoreId, restoreBlobs, undeleteBlobs, dryRun);
        this.blobStoreIntegrityCheck(integrityCheck, blobStoreId);
        return null;
    }

    private void restore(String blobStoreName, boolean restore, boolean undelete, boolean dryRun) {
        if (!restore && !undelete) {
            this.log.warn("No repair/restore operations selected");
            return;
        }
        String logPrefix = dryRun ? this.dryRunPrefix.get() : "";
        BlobStore store = this.blobStoreManager.get(blobStoreName);
        ProgressLogIntervalHelper progressLogger = new ProgressLogIntervalHelper(this.log, 60);
        long processed = 0L;
        long undeleted = 0L;
        boolean updateAssets = !dryRun && restore;
        HashSet<Repository> touchedRepositories = new HashSet<Repository>();
        if (dryRun) {
            this.log.info("{}Actions will be logged, but no changes will be made.", (Object)logPrefix);
        }
        for (BlobId blobId : store.getBlobIdStream()::iterator) {
            Optional<Context> context = this.buildContext(blobStoreName, store, blobId);
            if (context.isPresent()) {
                Context c = context.get();
                if (restore && c.restoreBlobStrategy != null && !c.blobAttributes.isDeleted()) {
                    c.restoreBlobStrategy.restore(c.properties, c.blob, c.blobStoreName, dryRun);
                }
                if (undelete && store.undelete(this.blobStoreUsageChecker, c.blobId, c.blobAttributes, dryRun)) {
                    ++undeleted;
                }
                if (updateAssets) {
                    touchedRepositories.add(c.repository);
                }
            }
            progressLogger.info("{}Elapsed time: {}, processed: {}, un-deleted: {}", new Object[]{logPrefix, progressLogger.getElapsed(), ++processed, undeleted});
            if (this.isCanceled()) break;
        }
        this.updateAssets(touchedRepositories, updateAssets);
        progressLogger.flush();
    }

    private void updateAssets(Set<Repository> repositories, boolean updateAssets) {
        for (Repository repository : repositories) {
            if (this.isCanceled()) break;
            Optional.ofNullable(this.restoreBlobStrategies.get(repository.getFormat().getValue())).ifPresent(strategy -> strategy.after(updateAssets, repository));
        }
    }

    private void blobStoreIntegrityCheck(boolean integrityCheck, String blobStoreId) {
        if (!integrityCheck) {
            this.log.warn("Integrity check operation not selected");
            return;
        }
        BlobStore blobStore = this.blobStoreManager.get(blobStoreId);
        if (blobStore == null) {
            this.log.error("Unable to find blob store '{}' in the blob store manager", (Object)blobStoreId);
            return;
        }
        StreamSupport.stream(this.repositoryManager.browseForBlobStore(blobStoreId).spliterator(), false).filter(r -> !(r.getType() instanceof GroupType)).forEach(repository -> this.integrityCheckStrategies.getOrDefault(repository.getFormat().getValue(), this.defaultIntegrityCheckStrategy).check((Repository)repository, blobStore, () -> ((RestoreMetadataTask)this).isCanceled()));
    }

    private Optional<Context> buildContext(String blobStoreName, BlobStore blobStore, BlobId blobId) {
        return Optional.of(new Context(blobStoreName, blobStore, blobId)).map(c -> c.blob(c.blobStore.get(c.blobId, true))).map(c -> c.blobAttributes(c.blobStore.getBlobAttributes(c.blobId))).map(c -> c.properties(c.blobAttributes.getProperties())).map(c -> c.repositoryName(c.properties.getProperty("@Bucket.repo-name"))).map(c -> c.repository(this.repositoryManager.get(c.repositoryName))).map(c -> c.restoreBlobStrategy(this.restoreBlobStrategies.get(c.repository.getFormat().getValue())));
    }

    private static class Context {
        final String blobStoreName;
        final BlobStore blobStore;
        final BlobId blobId;
        Blob blob;
        BlobAttributes blobAttributes;
        Properties properties;
        String repositoryName;
        Repository repository;
        RestoreBlobStrategy restoreBlobStrategy;

        Context(String blobStoreName, BlobStore blobStore, BlobId blobId) {
            this.blobStoreName = (String)Preconditions.checkNotNull((Object)blobStoreName);
            this.blobStore = (BlobStore)Preconditions.checkNotNull((Object)blobStore);
            this.blobId = (BlobId)Preconditions.checkNotNull((Object)blobId);
        }

        Context blob(Blob blob) {
            if (blob == null) {
                return null;
            }
            this.blob = blob;
            return this;
        }

        Context blobAttributes(BlobAttributes blobAttributes) {
            if (blobAttributes == null) {
                return null;
            }
            this.blobAttributes = blobAttributes;
            return this;
        }

        Context properties(Properties properties) {
            if (properties == null) {
                return null;
            }
            this.properties = properties;
            return this;
        }

        Context repositoryName(String repositoryName) {
            if (repositoryName == null) {
                return null;
            }
            this.repositoryName = repositoryName;
            return this;
        }

        Context repository(Repository repository) {
            if (repository == null) {
                return null;
            }
            this.repository = repository;
            return this;
        }

        Context restoreBlobStrategy(RestoreBlobStrategy restoreBlobStrategy) {
            this.restoreBlobStrategy = restoreBlobStrategy;
            return this;
        }
    }
}

