/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.restore;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.blobstore.restore.RestoreMetadataTask;
import org.sonatype.nexus.formfields.CheckboxFormField;
import org.sonatype.nexus.formfields.ComboboxFormField;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.scheduling.TaskDescriptorSupport;

@Named
@Singleton
public class RestoreMetadataTaskDescriptor
extends TaskDescriptorSupport {
    static final String TYPE_ID = "blobstore.rebuildComponentDB";
    static final String BLOB_STORE_NAME_FIELD_ID = "blobstoreName";
    static final String RESTORE_BLOBS = "restoreBlobs";
    static final String UNDELETE_BLOBS = "undeleteBlobs";
    static final String INTEGRITY_CHECK = "integrityCheck";
    static final String DRY_RUN = "dryRun";
    private static final Messages messages = (Messages)I18N.create(Messages.class);

    RestoreMetadataTaskDescriptor() {
        super(TYPE_ID, RestoreMetadataTask.class, messages.name(), true, true, new FormField[]{new ComboboxFormField(BLOB_STORE_NAME_FIELD_ID, messages.blobstoreNameLabel(), messages.blobstoreNameHelpText(), true).withStoreApi("coreui_Blobstore.read").withIdMapping("name"), new CheckboxFormField(DRY_RUN, messages.dryRunLabel(), messages.dryRunHelpText(), false).withInitialValue(Boolean.valueOf(false)), new CheckboxFormField(RESTORE_BLOBS, messages.restoreBlobsLabel(), messages.restoreBlobsHelpText(), false).withInitialValue(Boolean.valueOf(true)), new CheckboxFormField(UNDELETE_BLOBS, messages.undeleteBlobsLabel(), messages.undeleteBlobsHelpText(), false).withInitialValue(Boolean.valueOf(true)), new CheckboxFormField(INTEGRITY_CHECK, messages.integrityCheckLabel(), messages.integrityCheckHelpText(), false).withInitialValue(Boolean.valueOf(true))});
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Repair - Reconcile component database from blob store")
        public String name();

        @MessageBundle.DefaultMessage(value="Blob store")
        public String blobstoreNameLabel();

        @MessageBundle.DefaultMessage(value="Select the blob store to restore")
        public String blobstoreNameHelpText();

        @MessageBundle.DefaultMessage(value="Restore blob metadata")
        public String restoreBlobsLabel();

        @MessageBundle.DefaultMessage(value="Restore missing metadata for blobs found in the blob store.")
        public String restoreBlobsHelpText();

        @MessageBundle.DefaultMessage(value="Un-delete referenced blobs")
        public String undeleteBlobsLabel();

        @MessageBundle.DefaultMessage(value="Un-delete blobs which still have metadata referencing them.")
        public String undeleteBlobsHelpText();

        @MessageBundle.DefaultMessage(value="Dry Run")
        public String dryRunLabel();

        @MessageBundle.DefaultMessage(value="Log actions, but make no changes.")
        public String dryRunHelpText();

        @MessageBundle.DefaultMessage(value="Integrity check")
        public String integrityCheckLabel();

        @MessageBundle.DefaultMessage(value="Verify integrity between asset metadata and blob properties")
        public String integrityCheckHelpText();
    }
}

