/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.util.Readable;

public abstract class AbstractSessionIoHandler
implements IoHandler {
    protected abstract AbstractSession createSession(IoSession var1) throws Exception;

    public void sessionCreated(IoSession ioSession) throws Exception {
        AbstractSession session = this.createSession(ioSession);
        AbstractSession.attachSession(ioSession, session);
    }

    public void sessionClosed(IoSession ioSession) throws Exception {
        AbstractSession.getSession(ioSession).close(true);
    }

    public void exceptionCaught(IoSession ioSession, Throwable cause) throws Exception {
        AbstractSession session = AbstractSession.getSession(ioSession, true);
        if (session == null) {
            throw new IllegalStateException("No session available", cause);
        }
        session.exceptionCaught(cause);
    }

    public void messageReceived(IoSession ioSession, Readable message) throws Exception {
        AbstractSession.getSession(ioSession).messageReceived(message);
    }
}

