/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Recipe;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.view.Router;
import org.sonatype.nexus.repository.view.handlers.BrowseUnsupportedHandler;

public abstract class RecipeSupport
extends ComponentSupport
implements Recipe {
    private final Format format;
    private final Type type;
    private BrowseUnsupportedHandler browseUnsupportedHandler;

    protected RecipeSupport(Type type, Format format) {
        this.type = (Type)Preconditions.checkNotNull((Object)type);
        this.format = (Format)Preconditions.checkNotNull((Object)format);
    }

    @Override
    public Format getFormat() {
        return this.format;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "format=" + this.format + ", type=" + this.type + '}';
    }

    @Inject
    public void setBrowseUnsupportedHandler(BrowseUnsupportedHandler browseUnsupportedHandler) {
        this.browseUnsupportedHandler = (BrowseUnsupportedHandler)Preconditions.checkNotNull((Object)browseUnsupportedHandler);
    }

    protected void addBrowseUnsupportedRoute(Router.Builder builder) {
        builder.route(this.browseUnsupportedHandler.getRoute());
    }

    @Override
    public boolean isFeatureEnabled() {
        return true;
    }
}

