/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.assetdownloadcount;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public class CacheEntryKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String repositoryName;
    private final String assetName;

    public CacheEntryKey(String repositoryName, String assetName) {
        this.repositoryName = (String)Preconditions.checkNotNull((Object)repositoryName);
        this.assetName = (String)Preconditions.checkNotNull((Object)assetName);
    }

    public String getAssetName() {
        return this.assetName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public int hashCode() {
        return Objects.hash(this.repositoryName, this.assetName);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CacheEntryKey)) {
            return false;
        }
        CacheEntryKey other = (CacheEntryKey)obj;
        if (other == this) {
            return true;
        }
        return Objects.equals(this.repositoryName, other.repositoryName) && Objects.equals(this.assetName, other.assetName);
    }

    public String toString() {
        return "CacheEntryKey for Repository:" + this.repositoryName + " Asset:" + this.assetName;
    }
}

