/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.assetdownloadcount;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import org.joda.time.DateTime;
import org.sonatype.nexus.repository.assetdownloadcount.internal.DateUtils;

@VisibleForTesting
public enum DateType {
    DAY(30),
    MONTH(14),
    MONTH_WHOLE_REPO(14),
    MONTH_WHOLE_REPO_VULNERABLE(14);

    private static final String UNIMPLEMENTED_DATE_TYPE_ENCOUNTERED = "Unimplemented DateType encountered ";
    private final int numberToKeep;

    private DateType(int numberToKeep) {
        this.numberToKeep = numberToKeep;
    }

    public int getNumberToKeep() {
        return this.numberToKeep;
    }

    public DateTime standardizeDate(DateTime date) {
        Preconditions.checkNotNull((Object)date);
        switch (this) {
            case DAY: {
                return DateUtils.clearTime(date);
            }
            case MONTH: 
            case MONTH_WHOLE_REPO: 
            case MONTH_WHOLE_REPO_VULNERABLE: {
                return DateUtils.clearDayAndTime(date);
            }
        }
        throw new IllegalArgumentException(UNIMPLEMENTED_DATE_TYPE_ENCOUNTERED + this.name());
    }

    public DateTime toOldestDate(DateTime date) {
        Preconditions.checkNotNull((Object)date);
        switch (this) {
            case DAY: {
                return date.minusDays(this.getNumberToKeep());
            }
            case MONTH: 
            case MONTH_WHOLE_REPO: 
            case MONTH_WHOLE_REPO_VULNERABLE: {
                return date.minusMonths(this.getNumberToKeep());
            }
        }
        throw new IllegalArgumentException(UNIMPLEMENTED_DATE_TYPE_ENCOUNTERED + this.name());
    }

    public DateTime decrement(DateTime date) {
        Preconditions.checkNotNull((Object)date);
        switch (this) {
            case DAY: {
                return date.minusDays(1);
            }
            case MONTH: 
            case MONTH_WHOLE_REPO: 
            case MONTH_WHOLE_REPO_VULNERABLE: {
                return date.minusMonths(1);
            }
        }
        throw new IllegalArgumentException(UNIMPLEMENTED_DATE_TYPE_ENCOUNTERED + this.name());
    }
}

