/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.assetdownloadcount.internal;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.assetdownloadcount.AssetDownloadCountStore;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.handlers.ContributedHandler;

@Named
@Singleton
public class AssetDownloadCountContributedHandler
extends ComponentSupport
implements ContributedHandler {
    private final AssetDownloadCountStore assetDownloadCountStore;

    @Inject
    public AssetDownloadCountContributedHandler(AssetDownloadCountStore assetDownloadCountStore) {
        this.assetDownloadCountStore = (AssetDownloadCountStore)Preconditions.checkNotNull((Object)assetDownloadCountStore);
    }

    @Override
    public Response handle(Context context) throws Exception {
        Asset asset;
        Response response = context.proceed();
        if (this.assetDownloadCountStore.isEnabled() && response != null && response.getStatus().isSuccessful() && this.isGetRequest(context.getRequest()) && (asset = this.getAssetFromPayload(response.getPayload())) != null) {
            this.assetDownloadCountStore.incrementCount(context.getRepository().getName(), asset.name());
        }
        return response;
    }

    private boolean isGetRequest(Request request) {
        return "GET".equals(request.getAction());
    }

    private Asset getAssetFromPayload(Payload payload) {
        if (payload instanceof Content) {
            return (Asset)((Content)payload).getAttributes().get(Asset.class);
        }
        return null;
    }
}

