/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.assetdownloadcount.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.repository.assetdownloadcount.DateType;
import org.sonatype.nexus.repository.assetdownloadcount.internal.AssetDownloadCount;

@Named
@Singleton
public class AssetDownloadCountEntityAdapter
extends IterableEntityAdapter<AssetDownloadCount> {
    private static final String DB_CLASS = new OClassNameBuilder().type("assetdownloadcount").build();
    public static final String P_REPOSITORY_NAME = "repository_name";
    public static final String P_ASSET_NAME = "asset_name";
    public static final String P_NODE_ID = "node_id";
    public static final String P_COUNT = "count";
    public static final String P_DATE_TYPE = "date_type";
    public static final String P_DATE = "date";
    private static final String DATED_COUNT_QUERY = String.format("select sum(%s) from %s where %s = :repositoryName and %s = :assetName and %s = :dateType and %s = :date", "count", DB_CLASS, "repository_name", "asset_name", "date_type", "date");
    private static final String DATED_COUNT_ALL_OF_REPO_QUERY = String.format("select sum(%s) from %s where %s = :repositoryName and %s = :assetName and %s = :dateType and %s = :date", "count", DB_CLASS, "repository_name", "asset_name", "date_type", "date");
    private static final String TOTAL_COUNT_QUERY = String.format("select sum(%s) from %s where %s = :repositoryName and %s = :assetName and %s = :dateType", "count", DB_CLASS, "repository_name", "asset_name", "date_type");
    private static final String UPDATE_COUNT_QUERY = String.format("update %s set count = :count, node_id = :nodeId, repository_name = :repositoryName, asset_name = :assetName, date_type = :dateType, date = :date upsert where %s = :nodeId and %s = :repositoryName and %s = :assetName and %s = :dateType and %s = :date", DB_CLASS, "node_id", "repository_name", "asset_name", "date_type", "date");
    private static final String REMOVE_OLD_QUERY = String.format("delete from %s where %s = :nodeId and %s = :dateType and %s < :date limit :limit", DB_CLASS, "node_id", "date_type", "date");
    private static final String ASSET_TOTAL_FOR_DATE_TYPE_QUERY = String.format("select from %s where %s = :repositoryName and %s = :assetName and %s = :dateType", DB_CLASS, "repository_name", "asset_name", "date_type");
    private static final String REPO_TOTAL_FOR_DATE_TYPE_QUERY = String.format("select from %s where %s = :repositoryName and %s = :dateType", DB_CLASS, "repository_name", "date_type");
    private static final String I_REPO_NAME_ASSET_NAME_DATE_TYPE_DATE = new OIndexNameBuilder().type(DB_CLASS).property("repository_name").property("asset_name").property("date_type").property("date").build();
    private static final String I_NODE_ID_REPO_NAME_ASSET_NAME_DATE_TYPE_DATE = new OIndexNameBuilder().type(DB_CLASS).property("node_id").property("repository_name").property("asset_name").property("date_type").property("date").build();
    private static final String I_NODE_ID_DATE_TYPE_DATE = new OIndexNameBuilder().type(DB_CLASS).property("node_id").property("date_type").property("date").build();
    private static final String I_REPO_NAME_DATE_TYPE_DATE = new OIndexNameBuilder().type(DB_CLASS).property("repository_name").property("date_type").build();
    private final String nodeId;
    private final int maxDeleteSize;

    @Inject
    public AssetDownloadCountEntityAdapter(NodeAccess nodeAccess, @Named(value="${nexus.assetdownloads.max.delete.size:-1000}") int maxDeleteSize) {
        super(DB_CLASS);
        this.nodeId = nodeAccess.getId();
        this.maxDeleteSize = maxDeleteSize;
    }

    protected void defineType(OClass type) {
        type.createProperty(P_REPOSITORY_NAME, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_ASSET_NAME, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_NODE_ID, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_COUNT, OType.LONG).setMandatory(true).setNotNull(true);
        type.createProperty(P_DATE_TYPE, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_DATE, OType.DATETIME).setMandatory(true).setNotNull(true);
        type.createIndex(I_REPO_NAME_ASSET_NAME_DATE_TYPE_DATE, OClass.INDEX_TYPE.NOTUNIQUE, new String[]{P_REPOSITORY_NAME, P_ASSET_NAME, P_DATE_TYPE, P_DATE});
        type.createIndex(I_NODE_ID_REPO_NAME_ASSET_NAME_DATE_TYPE_DATE, OClass.INDEX_TYPE.NOTUNIQUE, new String[]{P_NODE_ID, P_REPOSITORY_NAME, P_ASSET_NAME, P_DATE_TYPE, P_DATE});
        type.createIndex(I_NODE_ID_DATE_TYPE_DATE, OClass.INDEX_TYPE.NOTUNIQUE, new String[]{P_NODE_ID, P_DATE_TYPE, P_DATE});
        type.createIndex(I_REPO_NAME_DATE_TYPE_DATE, OClass.INDEX_TYPE.NOTUNIQUE, new String[]{P_REPOSITORY_NAME, P_DATE_TYPE});
    }

    protected AssetDownloadCount newEntity() {
        return new AssetDownloadCount();
    }

    protected void readFields(ODocument document, AssetDownloadCount entity) {
        String repositoryName = (String)document.field(P_REPOSITORY_NAME, OType.STRING);
        String assetName = (String)document.field(P_ASSET_NAME, OType.STRING);
        String nodeId = (String)document.field(P_NODE_ID, OType.STRING);
        Long count = (Long)document.field(P_COUNT, OType.LONG);
        DateType dateType = DateType.valueOf((String)document.field(P_DATE_TYPE, OType.STRING));
        Date date = (Date)document.field(P_DATE, OType.DATETIME);
        entity.withRepositoryName(repositoryName).withNodeId(nodeId).withDateType(dateType).withDate(new DateTime((Object)date)).withCount(count);
        if (assetName != null) {
            entity.withAssetName(assetName);
        }
    }

    protected void writeFields(ODocument document, AssetDownloadCount entity) {
        document.field(P_REPOSITORY_NAME, (Object)entity.getRepositoryName());
        document.field(P_ASSET_NAME, (Object)entity.getAssetName());
        document.field(P_NODE_ID, (Object)entity.getNodeId());
        document.field(P_COUNT, (Object)entity.getCount());
        document.field(P_DATE_TYPE, (Object)entity.getDateType());
        document.field(P_DATE, (Object)entity.getDate().toDate());
    }

    public long getCount(ODatabaseDocumentTx db, String repositoryName, String assetName) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)repositoryName);
        Preconditions.checkNotNull((Object)assetName);
        Map<String, Object> parameters = this.buildQueryParameters(repositoryName, assetName, DateType.DAY, null, null);
        Iterable docs = (Iterable)db.command((OCommandRequest)new OCommandSQL(TOTAL_COUNT_QUERY)).execute(new Object[]{parameters});
        ODocument result = (ODocument)Iterables.getFirst((Iterable)docs, null);
        if (result != null) {
            return (Long)result.field("sum", OType.LONG);
        }
        return 0L;
    }

    public long getCount(ODatabaseDocumentTx db, String repositoryName, String assetName, DateType dateType) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)repositoryName);
        Preconditions.checkNotNull((Object)assetName);
        Preconditions.checkNotNull((Object)((Object)dateType));
        Map<String, Object> parameters = this.buildQueryParameters(repositoryName, assetName, dateType, null, null);
        String query = String.format("select sum(%s) from %s where %s = :repositoryName and %s = :assetName and %s = :dateType", P_COUNT, DB_CLASS, P_REPOSITORY_NAME, P_ASSET_NAME, P_DATE_TYPE);
        Iterable docs = (Iterable)db.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[]{parameters});
        ODocument result = (ODocument)Iterables.getFirst((Iterable)docs, null);
        if (result != null) {
            return (Long)result.field("sum", OType.LONG);
        }
        return 0L;
    }

    public long getCount(ODatabaseDocumentTx db, String repositoryName, DateType dateType, DateTime date) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)repositoryName);
        Preconditions.checkNotNull((Object)((Object)dateType));
        Preconditions.checkNotNull((Object)date);
        Map<String, Object> parameters = this.buildQueryParameters(repositoryName, "", dateType, date, null);
        Iterable docs = (Iterable)db.command((OCommandRequest)new OCommandSQL(DATED_COUNT_ALL_OF_REPO_QUERY)).execute(new Object[]{parameters});
        ODocument result = (ODocument)Iterables.getFirst((Iterable)docs, null);
        if (result != null) {
            return (Long)result.field("sum", OType.LONG);
        }
        return 0L;
    }

    public long getCount(ODatabaseDocumentTx db, String repositoryName, String assetName, DateType dateType, DateTime date) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)repositoryName);
        Preconditions.checkNotNull((Object)assetName);
        Preconditions.checkNotNull((Object)((Object)dateType));
        Preconditions.checkNotNull((Object)date);
        Map<String, Object> parameters = this.buildQueryParameters(repositoryName, assetName, dateType, date, null);
        Iterable docs = (Iterable)db.command((OCommandRequest)new OCommandSQL(DATED_COUNT_QUERY)).execute(new Object[]{parameters});
        ODocument result = (ODocument)Iterables.getFirst((Iterable)docs, null);
        if (result != null) {
            return (Long)result.field("sum", OType.LONG);
        }
        return 0L;
    }

    public void incrementCount(ODatabaseDocumentTx db, String repositoryName, String assetName, long count) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)repositoryName);
        Preconditions.checkNotNull((Object)assetName);
        DateTime now = new DateTime();
        this.incrementCount(db, repositoryName, assetName, this.nodeId, DateType.DAY, now, count);
        this.incrementCount(db, repositoryName, assetName, this.nodeId, DateType.MONTH, now, count);
    }

    public long[] getCounts(ODatabaseDocumentTx db, String repositoryName, String assetName, DateType dateType) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)repositoryName);
        Preconditions.checkNotNull((Object)assetName);
        Preconditions.checkNotNull((Object)((Object)dateType));
        Map<String, Object> parameters = this.buildQueryParameters(repositoryName, assetName, dateType, null, null);
        Iterable docs = (Iterable)db.command((OCommandRequest)new OCommandSQL(ASSET_TOTAL_FOR_DATE_TYPE_QUERY)).execute(new Object[]{parameters});
        return this.getCounts(docs, dateType);
    }

    public void setCount(ODatabaseDocumentTx db, String repositoryName, DateType dateType, DateTime date, long count) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)repositoryName);
        Preconditions.checkNotNull((Object)date);
        Map<String, Object> parameters = this.buildQueryParameters(repositoryName, "", dateType, date, this.nodeId);
        parameters.put(P_COUNT, count);
        db.command((OCommandRequest)new OCommandSQL(UPDATE_COUNT_QUERY)).execute(new Object[]{parameters});
    }

    public long[] getCounts(ODatabaseDocumentTx db, String repositoryName, DateType dateType) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)repositoryName);
        Preconditions.checkNotNull((Object)((Object)dateType));
        Map<String, Object> parameters = this.buildQueryParameters(repositoryName, "", dateType, null, null);
        Iterable docs = (Iterable)db.command((OCommandRequest)new OCommandSQL(REPO_TOTAL_FOR_DATE_TYPE_QUERY)).execute(new Object[]{parameters});
        return this.getCounts(docs, dateType);
    }

    public int removeOldRecords(ODatabaseDocumentTx db, DateType dateType) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)((Object)dateType));
        DateTime date = dateType.toOldestDate(new DateTime());
        Map<String, Object> parameters = this.buildQueryParameters(null, "", dateType, date, this.nodeId);
        parameters.put("limit", this.maxDeleteSize);
        return (Integer)db.command((OCommandRequest)new OCommandSQL(REMOVE_OLD_QUERY)).execute(new Object[]{parameters});
    }

    public int getMaxDeleteSize() {
        return this.maxDeleteSize;
    }

    private Map<String, Object> buildQueryParameters(String repositoryName, String assetName, DateType dateType, DateTime date, String nodeId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (repositoryName != null) {
            params.put("repositoryName", repositoryName);
        }
        if (assetName != null) {
            params.put("assetName", assetName);
        }
        if (dateType != null) {
            params.put("dateType", (Object)dateType);
        }
        if (date != null) {
            params.put(P_DATE, dateType.standardizeDate(date).toDate());
        }
        if (nodeId != null) {
            params.put("nodeId", nodeId);
        }
        return params;
    }

    private void incrementCount(ODatabaseDocumentTx db, String repositoryName, String assetName, String nodeId, DateType dateType, DateTime date, long count) {
        Map<String, Object> parameters = this.buildQueryParameters(repositoryName, assetName, dateType, date, nodeId);
        String query = String.format("update %s increment count = %s where %s = :nodeId and %s = :repositoryName and %s = :assetName and %s = :dateType and %s = :date", DB_CLASS, count, P_NODE_ID, P_REPOSITORY_NAME, P_ASSET_NAME, P_DATE_TYPE, P_DATE);
        Integer updateCount = (Integer)db.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[]{parameters});
        if (updateCount < 1) {
            this.addEntity(db, (Entity)this.newEntity().withRepositoryName(repositoryName).withAssetName(assetName).withNodeId(nodeId).withDateType(dateType).withDate(new DateTime((Object)dateType.standardizeDate(date))).withCount(count));
        }
    }

    private long[] getCounts(Iterable<ODocument> docs, DateType dateType) {
        int numberToKeep = dateType.getNumberToKeep();
        long[] counts = new long[numberToKeep];
        DateTime current = dateType.standardizeDate(DateTime.now());
        DateTime oldest = dateType.toOldestDate(current);
        HashMap<DateTime, Long> dateCountMap = new HashMap<DateTime, Long>();
        for (ODocument doc : docs) {
            AssetDownloadCount assetDownloadCount = (AssetDownloadCount)this.readEntity(doc);
            dateCountMap.put(assetDownloadCount.getDate(), dateCountMap.getOrDefault(assetDownloadCount.getDate(), 0L) + assetDownloadCount.getCount());
        }
        int i = 0;
        while (i < numberToKeep && oldest.isBefore((ReadableInstant)current)) {
            counts[i] = dateCountMap.getOrDefault(current, 0L);
            current = dateType.decrement(current);
            ++i;
        }
        return counts;
    }
}

