/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.assetdownloadcount.internal;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.cache.Cache;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.MutableEntry;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.sonatype.goodies.lifecycle.Lifecycle;
import org.sonatype.nexus.cache.CacheHelper;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.repository.assetdownloadcount.AssetDownloadCountStore;
import org.sonatype.nexus.repository.assetdownloadcount.CacheEntryKey;
import org.sonatype.nexus.repository.assetdownloadcount.DateType;
import org.sonatype.nexus.repository.assetdownloadcount.internal.AssetDownloadCountEntityAdapter;
import org.sonatype.nexus.repository.assetdownloadcount.internal.AssetDownloadHistoricDataCleaner;
import org.sonatype.nexus.repository.assetdownloadcount.internal.CacheRemovalListener;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
public class AssetDownloadCountStoreImpl
extends StateGuardLifecycleSupport
implements AssetDownloadCountStore,
Lifecycle {
    private final Provider<DatabaseInstance> databaseInstance;
    private final AssetDownloadCountEntityAdapter entityAdapter;
    private final boolean enabled;
    private final AssetDownloadHistoricDataCleaner historicDataCleaner;
    private Cache<CacheEntryKey, Long> cache = null;
    private final EntryIncrementProcessor entryIncrementProcessor;
    private final CacheHelper cacheHelper;
    private final int cacheSize;
    private final int cacheDuration;
    private final CacheRemovalListener cacheRemovalListener;

    @Inject
    public AssetDownloadCountStoreImpl(@Named(value="component") Provider<DatabaseInstance> databaseInstance, @Named(value="${nexus.assetdownloads.enabled:-false}") boolean enabled, @Named(value="${nexus.assetdownloads.cache.size:-10000}") int cacheSize, @Named(value="${nexus.assetdownloads.cache.duration:-3600}") int cacheDuration, AssetDownloadCountEntityAdapter entityAdapter, AssetDownloadHistoricDataCleaner historicDataCleaner, CacheRemovalListener cacheRemovalListener, CacheHelper cacheHelper) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (AssetDownloadCountEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
        this.historicDataCleaner = (AssetDownloadHistoricDataCleaner)Preconditions.checkNotNull((Object)historicDataCleaner);
        this.cacheHelper = (CacheHelper)Preconditions.checkNotNull((Object)cacheHelper);
        this.enabled = enabled;
        this.cacheSize = cacheSize;
        this.cacheDuration = cacheDuration;
        this.cacheRemovalListener = (CacheRemovalListener)Preconditions.checkNotNull((Object)cacheRemovalListener);
        this.entryIncrementProcessor = new EntryIncrementProcessor();
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (this.cache == null) {
            this.cache = this.cacheHelper.getOrCreate(this.cacheHelper.builder().name("assetDownloadCountStoreCache").cacheSize(this.cacheSize).expiryFactory(CreatedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.SECONDS, (long)this.cacheDuration))).keyType(CacheEntryKey.class).valueType(Long.class).persister((BiConsumer)this.cacheRemovalListener));
        }
    }

    protected void doStop() {
        this.historicDataCleaner.stop();
        if (this.cache != null) {
            this.log.debug("Saving asset download count cache to DB");
            this.cache.forEach(entry -> this.cacheRemovalListener.accept((CacheEntryKey)entry.getKey(), (Long)entry.getValue()));
            this.cache.clear();
            this.log.debug("Asset download counts saved successfully");
        }
        this.cache = null;
    }

    @Override
    @Guarded(by={"STARTED"})
    public long getDailyCount(String repositoryName, String assetName, DateTime date) {
        long count = (Long)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getCount(db, repositoryName, assetName, DateType.DAY, date));
        this.log.debug("Get daily count for {} {} {} return {}", new Object[]{repositoryName, assetName, date, count});
        return count;
    }

    @Override
    @Guarded(by={"STARTED"})
    public long getMonthlyCount(String repositoryName, String assetName, DateTime date) {
        long count = (Long)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getCount(db, repositoryName, assetName, DateType.MONTH, date));
        this.log.debug("Get monthly count for {} {} {} return {}", new Object[]{repositoryName, assetName, date, count});
        return count;
    }

    @Override
    @Guarded(by={"STARTED"})
    public long[] getDailyCounts(String repositoryName, String assetName) {
        long[] counts = (long[])OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getCounts(db, repositoryName, assetName, DateType.DAY));
        this.log.debug("Get daily counts for {} {} {}", new Object[]{repositoryName, assetName, counts});
        return counts;
    }

    @Override
    @Guarded(by={"STARTED"})
    public long[] getMonthlyCounts(String repositoryName, String assetName) {
        long[] counts = (long[])OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getCounts(db, repositoryName, assetName, DateType.MONTH));
        this.log.debug("Get monthly counts for {} {} {}", new Object[]{repositoryName, assetName, counts});
        return counts;
    }

    @Override
    @Guarded(by={"STARTED"})
    public void incrementCount(String repositoryName, String assetName) {
        if (this.cache != null) {
            long newValue = (Long)this.cache.invoke((Object)new CacheEntryKey(repositoryName, assetName), (EntryProcessor)this.entryIncrementProcessor, new Object[0]);
            this.log.debug("Incremented cached count for {} {} by 1 to {}", new Object[]{repositoryName, assetName, newValue});
        }
        this.historicDataCleaner.start();
    }

    @Override
    @Guarded(by={"STARTED"})
    public void setMonthlyVulnerableCount(String repositoryName, DateTime date, long count) {
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            this.entityAdapter.setCount(db, repositoryName, DateType.MONTH_WHOLE_REPO_VULNERABLE, date, count);
            this.log.debug("Setting monthly vulnerability count {} {} {}", new Object[]{repositoryName, date, count});
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public void setMonthlyCount(String repositoryName, DateTime date, long count) {
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            this.entityAdapter.setCount(db, repositoryName, DateType.MONTH_WHOLE_REPO, date, count);
            this.log.debug("Setting monthly count {} {} {}", new Object[]{repositoryName, date, count});
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public long[] getMonthlyCounts(String repositoryName) {
        return (long[])OrientTransactional.inTx(this.databaseInstance).call(db -> {
            long[] counts = this.entityAdapter.getCounts(db, repositoryName, DateType.MONTH_WHOLE_REPO);
            this.log.debug("Get monthly counts for  {} {}", (Object)repositoryName, (Object)counts);
            return counts;
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public long[] getMonthlyVulnerableCounts(String repositoryName) {
        return (long[])OrientTransactional.inTx(this.databaseInstance).call(db -> {
            long[] counts = this.entityAdapter.getCounts(db, repositoryName, DateType.MONTH_WHOLE_REPO_VULNERABLE);
            this.log.debug("Get monthly vulnerable counts for  {} {}", (Object)repositoryName, (Object)counts);
            return counts;
        });
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    @Guarded(by={"STARTED"})
    public long getLastThirtyDays(String repositoryName, String assetName) {
        long lastThirty = 0L;
        long[] lArray = this.getDailyCounts(repositoryName, assetName);
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long day = lArray[n2];
            lastThirty += day;
            ++n2;
        }
        if (this.cache != null) {
            Long cachedDownloadCount = (Long)this.cache.get((Object)new CacheEntryKey(repositoryName, assetName));
            lastThirty += cachedDownloadCount == null ? 0L : cachedDownloadCount;
        }
        this.log.debug("Last thirty days downloads for {} {} is {}", new Object[]{repositoryName, assetName, lastThirty});
        return lastThirty;
    }

    private static class EntryIncrementProcessor
    implements EntryProcessor<CacheEntryKey, Long, Long>,
    Serializable {
        private EntryIncrementProcessor() {
        }

        public Long process(MutableEntry<CacheEntryKey, Long> mutableEntry, Object ... objects) {
            Long originalValue = (Long)mutableEntry.getValue();
            long newValue = originalValue == null ? 1L : originalValue + 1L;
            mutableEntry.setValue((Object)newValue);
            return newValue;
        }
    }
}

