/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.assetdownloadcount.internal;

import com.google.common.base.Preconditions;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.repository.assetdownloadcount.DateType;
import org.sonatype.nexus.repository.assetdownloadcount.internal.AssetDownloadCountEntityAdapter;
import org.sonatype.nexus.thread.NexusExecutorService;
import org.sonatype.nexus.thread.NexusThreadFactory;

@Named
@Singleton
public class AssetDownloadHistoricDataCleaner
extends ComponentSupport
implements Runnable {
    private final Provider<DatabaseInstance> databaseInstance;
    private final AssetDownloadCountEntityAdapter assetDownloadCountEntityAdapter;
    private final long interval;
    private final ExecutorService executorService;
    private final AtomicBoolean running = new AtomicBoolean();
    private static final String ERROR_MSG = "will restart process on next download count increment request";

    @Inject
    public AssetDownloadHistoricDataCleaner(@Named(value="component") Provider<DatabaseInstance> databaseInstance, AssetDownloadCountEntityAdapter assetDownloadCountEntityAdapter, @Named(value="${nexus.assetdownloads.historicdata.cleaner.interval:-86400}") long interval) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.assetDownloadCountEntityAdapter = (AssetDownloadCountEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)assetDownloadCountEntityAdapter)));
        this.interval = interval;
        this.executorService = NexusExecutorService.forCurrentSubject((ExecutorService)Executors.newSingleThreadExecutor((ThreadFactory)new NexusThreadFactory("assetdownloads-cleaner", "Asset Downloads Historic Data Cleaner", 1)));
    }

    public void start() {
        if (!this.running.getAndSet(true)) {
            this.executorService.submit(this);
        }
    }

    public void stop() {
        this.running.set(false);
        this.executorService.shutdownNow();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void run() {
        do {
            try {
                this.doDelete();
                Thread.sleep(this.interval * 1000L);
            }
            catch (InterruptedException interruptedException) {
                this.log.debug("Periodic checks interrupted, {}", (Object)ERROR_MSG);
                this.running.set(false);
            }
            catch (Exception e) {
                this.log.debug("Periodic checks failed, {}", (Object)ERROR_MSG, (Object)e);
                this.running.set(false);
            }
        } while (this.running.get());
    }

    private void doDelete() throws Exception {
        DateType[] dateTypeArray = DateType.values();
        int n = dateTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            int removedCount;
            DateType dateType = dateTypeArray[n2];
            do {
                removedCount = (Integer)OrientTransactional.inTxRetry(this.databaseInstance).call(db -> this.assetDownloadCountEntityAdapter.removeOldRecords(db, dateType));
                this.log.debug("Removed {} old records of type {}", (Object)removedCount, (Object)dateType.name());
                Thread.yield();
            } while (removedCount > 0 && removedCount == this.assetDownloadCountEntityAdapter.getMaxDeleteSize());
            ++n2;
        }
    }
}

