/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.assetdownloadcount.internal;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.repository.assetdownloadcount.CacheEntryKey;
import org.sonatype.nexus.repository.assetdownloadcount.internal.AssetDownloadCountEntityAdapter;

@Named
@Singleton
public class CacheRemovalListener
extends ComponentSupport
implements Serializable,
BiConsumer<CacheEntryKey, Long> {
    private static final long serialVersionUID = 1L;
    private final transient Provider<AssetDownloadCountEntityAdapter> entityAdapter;
    private final transient Provider<DatabaseInstance> databaseInstance;
    private final transient Provider<NodeAccess> nodeAccess;

    @Inject
    public CacheRemovalListener(@Named(value="component") Provider<DatabaseInstance> databaseInstance, Provider<AssetDownloadCountEntityAdapter> entityAdapter, Provider<NodeAccess> nodeAccess) {
        this.entityAdapter = (Provider)Preconditions.checkNotNull(entityAdapter);
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.nodeAccess = (Provider)Preconditions.checkNotNull(nodeAccess);
    }

    @Override
    public void accept(CacheEntryKey key, Long value) {
        if (!((NodeAccess)this.nodeAccess.get()).isClustered() || ((NodeAccess)this.nodeAccess.get()).isOldestNode()) {
            if (!((DatabaseInstance)this.databaseInstance.get()).isFrozen()) {
                OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
                    ((AssetDownloadCountEntityAdapter)((Object)((Object)this.entityAdapter.get()))).incrementCount(db, key.getRepositoryName(), key.getAssetName(), value);
                    this.log.debug("Incremented count(DB) {} {} by {}", new Object[]{key.getRepositoryName(), key.getAssetName(), value});
                });
            } else {
                this.log.warn("Dropping download count increment of {} for {}", (Object)value, (Object)key);
            }
        }
    }
}

