/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse;

import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.Time;

@Named
public class BrowseNodeConfiguration {
    private final boolean automaticRebuild;
    private final int rebuildPageSize;
    private final int deletePageSize;
    private final int maxNodes;
    private final int maxHtmlNodes;
    private final Time queryTimeout;

    @Inject
    public BrowseNodeConfiguration(@Named(value="${nexus.browse.component.tree.automaticRebuild:-true}") boolean automaticRebuild, @Named(value="${nexus.browse.component.tree.rebuildPageSize:-1000}") int rebuildPageSize, @Named(value="${nexus.browse.component.tree.deletePageSize:-1000}") int deletePageSize, @Named(value="${nexus.browse.component.tree.maxNodes:-10000}") int maxNodes, @Named(value="${nexus.browse.component.tree.maxHtmlNodes:-10000}") int maxHtmlNodes, @Named(value="${nexus.browse.component.tree.queryTimeout:-59s}") Time queryTimeout) {
        this.automaticRebuild = automaticRebuild;
        this.rebuildPageSize = rebuildPageSize;
        this.deletePageSize = deletePageSize;
        this.maxNodes = maxNodes;
        this.maxHtmlNodes = maxHtmlNodes;
        this.queryTimeout = queryTimeout;
    }

    @VisibleForTesting
    public BrowseNodeConfiguration() {
        this(true, 1000, 1000, 10000, 10000, Time.seconds((long)0L));
    }

    public int getRebuildPageSize() {
        return this.rebuildPageSize;
    }

    public int getDeletePageSize() {
        return this.deletePageSize;
    }

    public int getMaxNodes() {
        return this.maxNodes;
    }

    public int getMaxHtmlNodes() {
        return this.maxHtmlNodes;
    }

    public Time getQueryTimeout() {
        return this.queryTimeout;
    }

    public boolean isAutomaticRebuildEnabled() {
        return this.automaticRebuild;
    }
}

