/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.internal;

import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.browse.BrowseFacet;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;

@Named
public class BrowseFacetImpl
extends FacetSupport
implements BrowseFacet {
    private final TaskScheduler taskScheduler;

    @Inject
    public BrowseFacetImpl(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    @Override
    public boolean isRebuilding() {
        String repositoryName = this.getRepository().getName();
        return this.taskScheduler.listsTasks().stream().filter(task -> "create.browse.nodes".equals(task.getTypeId())).filter(task -> TaskInfo.State.RUNNING.equals((Object)task.getCurrentState().getState())).anyMatch(task -> {
            String taskRepositoryName = task.getConfiguration().getString("repositoryName");
            return taskRepositoryName.equals(repositoryName) || taskRepositoryName.equals("*");
        });
    }
}

