/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.orient.ReplicationModeOverrides;
import org.sonatype.nexus.repository.browse.internal.BrowseNodeManager;
import org.sonatype.nexus.repository.config.internal.ConfigurationDeletedEvent;
import org.sonatype.nexus.repository.storage.AssetCreatedEvent;
import org.sonatype.nexus.repository.storage.AssetDeletedEvent;
import org.sonatype.nexus.repository.storage.ComponentDeletedEvent;

@Singleton
@Named
public class BrowseNodeEventHandler
implements EventAware,
EventAware.Asynchronous {
    private final BrowseNodeManager browseNodeManager;

    @Inject
    public BrowseNodeEventHandler(BrowseNodeManager browseNodeManager) {
        this.browseNodeManager = (BrowseNodeManager)((Object)Preconditions.checkNotNull((Object)((Object)browseNodeManager)));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(AssetCreatedEvent event) {
        this.handle(event, e -> this.browseNodeManager.createFromAsset(e.getRepositoryName(), e.getAsset()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(AssetDeletedEvent event) {
        this.handle(event, e -> this.browseNodeManager.deleteAssetNode(e.getAssetId()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(ComponentDeletedEvent event) {
        this.handle(event, e -> this.browseNodeManager.deleteComponentNode(e.getComponentId()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(ConfigurationDeletedEvent event) {
        this.handle(event, e -> this.browseNodeManager.deleteByRepository(e.getRepositoryName()));
    }

    private <E extends EntityEvent> void handle(E event, Consumer<E> consumer) {
        Preconditions.checkNotNull(event);
        if (event.isLocal()) {
            ReplicationModeOverrides.dontWaitForReplicationResults();
            try {
                consumer.accept(event);
            }
            finally {
                ReplicationModeOverrides.clearReplicationModeOverrides();
            }
        }
    }
}

