/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.browse.BrowseNodeGenerator;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.BrowseNodeStore;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentStore;

@Named
@Singleton
public class BrowseNodeManager
extends ComponentSupport {
    private static final String DEFAULT_PATH_HANDLER = "default";
    private final BrowseNodeStore browseNodeStore;
    private final ComponentStore componentStore;
    private final Map<String, BrowseNodeGenerator> pathGenerators;
    private final BrowseNodeGenerator defaultGenerator;

    @Inject
    public BrowseNodeManager(BrowseNodeStore browseNodeStore, ComponentStore componentStore, Map<String, BrowseNodeGenerator> pathGenerators) {
        this.browseNodeStore = (BrowseNodeStore)Preconditions.checkNotNull((Object)browseNodeStore);
        this.componentStore = (ComponentStore)Preconditions.checkNotNull((Object)componentStore);
        this.pathGenerators = (Map)Preconditions.checkNotNull(pathGenerators);
        this.defaultGenerator = (BrowseNodeGenerator)Preconditions.checkNotNull((Object)pathGenerators.get(DEFAULT_PATH_HANDLER));
    }

    public void createFromAsset(String repositoryName, Asset asset) {
        Preconditions.checkNotNull((Object)repositoryName);
        Preconditions.checkNotNull((Object)asset);
        BrowseNodeGenerator generator = this.pathGenerators.getOrDefault(asset.format(), this.defaultGenerator);
        this.createBrowseNodes(repositoryName, generator, asset);
    }

    public void createFromAssets(Repository repository, Iterable<Asset> assets) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull(assets);
        String repositoryName = repository.getName();
        BrowseNodeGenerator generator = this.pathGenerators.getOrDefault(repository.getFormat().getValue(), this.defaultGenerator);
        assets.forEach(asset -> this.createBrowseNodes(repositoryName, generator, (Asset)asset));
    }

    private void createBrowseNodes(String repositoryName, BrowseNodeGenerator generator, Asset asset) {
        try {
            List<String> componentPath;
            Component component = asset.componentId() != null ? this.componentStore.read(asset.componentId()) : null;
            List<String> assetPath = generator.computeAssetPath(asset, component);
            if (!assetPath.isEmpty()) {
                this.browseNodeStore.createAssetNode(repositoryName, assetPath, asset);
            }
            if (component != null && !(componentPath = generator.computeComponentPath(asset, component)).isEmpty()) {
                this.browseNodeStore.createComponentNode(repositoryName, componentPath, component);
            }
        }
        catch (RuntimeException e) {
            this.log.warn("Problem generating browse nodes for {}", (Object)asset, (Object)e);
        }
    }

    public void deleteAssetNode(EntityId assetId) {
        this.browseNodeStore.deleteAssetNode(assetId);
    }

    public void deleteComponentNode(EntityId componentId) {
        this.browseNodeStore.deleteComponentNode(componentId);
    }

    public void deleteByRepository(String repositoryName) {
        this.browseNodeStore.deleteByRepository(repositoryName);
    }
}

