/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.assetdownloadcount.AssetDownloadCountStore;
import org.sonatype.nexus.repository.browse.BrowseResult;
import org.sonatype.nexus.repository.browse.BrowseService;
import org.sonatype.nexus.repository.browse.QueryOptions;
import org.sonatype.nexus.repository.browse.internal.BrowseAssetsSqlBuilder;
import org.sonatype.nexus.repository.browse.internal.BrowseComponentsSqlBuilder;
import org.sonatype.nexus.repository.browse.internal.PreviewAssetsSqlBuilder;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.RepositorySelector;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.BucketStore;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentEntityAdapter;
import org.sonatype.nexus.repository.storage.MetadataNode;
import org.sonatype.nexus.repository.storage.MetadataNodeEntityAdapter;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
public class BrowseServiceImpl
extends ComponentSupport
implements BrowseService {
    private final Type groupType;
    private final ComponentEntityAdapter componentEntityAdapter;
    private final AssetDownloadCountStore assetDownloadCountStore;
    private final AssetEntityAdapter assetEntityAdapter;
    private final VariableResolverAdapterManager variableResolverAdapterManager;
    private final ContentPermissionChecker contentPermissionChecker;
    private final BrowseAssetsSqlBuilder browseAssetsSqlBuilder;
    private final BrowseComponentsSqlBuilder browseComponentsSqlBuilder;
    private final BucketStore bucketStore;
    private final RepositoryManager repositoryManager;

    @Inject
    public BrowseServiceImpl(@Named(value="group") Type groupType, ComponentEntityAdapter componentEntityAdapter, VariableResolverAdapterManager variableResolverAdapterManager, ContentPermissionChecker contentPermissionChecker, AssetDownloadCountStore assetDownloadCountStore, AssetEntityAdapter assetEntityAdapter, BrowseAssetsSqlBuilder browseAssetsSqlBuilder, BrowseComponentsSqlBuilder browseComponentsSqlBuilder, BucketStore bucketStore, RepositoryManager repositoryManager) {
        this.groupType = (Type)Preconditions.checkNotNull((Object)groupType);
        this.componentEntityAdapter = (ComponentEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)componentEntityAdapter)));
        this.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
        this.contentPermissionChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)contentPermissionChecker);
        this.assetDownloadCountStore = (AssetDownloadCountStore)Preconditions.checkNotNull((Object)assetDownloadCountStore);
        this.assetEntityAdapter = (AssetEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)assetEntityAdapter)));
        this.browseAssetsSqlBuilder = (BrowseAssetsSqlBuilder)((Object)Preconditions.checkNotNull((Object)((Object)browseAssetsSqlBuilder)));
        this.browseComponentsSqlBuilder = (BrowseComponentsSqlBuilder)((Object)Preconditions.checkNotNull((Object)((Object)browseComponentsSqlBuilder)));
        this.bucketStore = (BucketStore)Preconditions.checkNotNull((Object)bucketStore);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    @Override
    public BrowseResult<Component> browseComponents(Repository repository, QueryOptions queryOptions) {
        Preconditions.checkNotNull((Object)repository);
        List<Repository> repositories = this.getRepositories(repository);
        Throwable throwable = null;
        Object var5_6 = null;
        try (StorageTx storageTx = (StorageTx)repository.facet(StorageFacet.class).txSupplier().get();){
            storageTx.begin();
            List<String> bucketIds = this.getBucketIds(storageTx, repositories);
            List<Object> components = Collections.emptyList();
            if (this.hasComponents(storageTx, repository, bucketIds, queryOptions)) {
                components = this.getComponents(storageTx.browse(this.browseComponentsSqlBuilder.buildBrowseSql(bucketIds, queryOptions), this.browseComponentsSqlBuilder.buildSqlParams(repository.getName(), queryOptions)));
            }
            return new BrowseResult<Component>(queryOptions, components);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean hasComponents(StorageTx storageTx, Repository repository, List<String> bucketIds, QueryOptions queryOptions) {
        QueryOptions adjustedOptions = new QueryOptions(queryOptions.getFilter(), null, null, 0, 1, null, false);
        Iterable<ODocument> docs = storageTx.browse(this.browseComponentsSqlBuilder.buildBrowseSql(bucketIds, adjustedOptions), this.browseComponentsSqlBuilder.buildSqlParams(repository.getName(), adjustedOptions));
        return docs.iterator().hasNext();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BrowseResult<Asset> browseComponentAssets(Repository repository, String componentId) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)componentId);
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            BrowseResult<Asset> browseResult;
            StorageTx storageTx = (StorageTx)repository.facet(StorageFacet.class).txSupplier().get();
            try {
                storageTx.begin();
                Component component = storageTx.findComponent((EntityId)new DetachedEntityId(componentId));
                if (component == null) {
                    browseResult = new BrowseResult<Asset>(0L, Collections.emptyList());
                    return browseResult;
                }
                return this.browseComponentAssetsHelper(storageTx, repository, component);
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (storageTx == null) return browseResult;
                storageTx.close();
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    @Override
    public BrowseResult<Asset> browseComponentAssets(Repository repository, Component component) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)component);
        Throwable throwable = null;
        Object var4_5 = null;
        try (StorageTx storageTx = (StorageTx)repository.facet(StorageFacet.class).txSupplier().get();){
            storageTx.begin();
            return this.browseComponentAssetsHelper(storageTx, repository, component);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private BrowseResult<Asset> browseComponentAssetsHelper(StorageTx storageTx, Repository repository, Component component) {
        HashSet<String> repoNames = new HashSet<String>(this.repositoryManager.findContainingGroups(repository.getName()));
        repoNames.add(repository.getName());
        VariableResolverAdapter variableResolverAdapter = this.variableResolverAdapterManager.get(component.format());
        List assets = StreamSupport.stream(storageTx.browseAssets(component).spliterator(), false).filter(asset -> this.contentPermissionChecker.isPermitted(repoNames, asset.format(), "browse", variableResolverAdapter.fromAsset((Asset)asset))).collect(Collectors.toList());
        return new BrowseResult<Asset>(assets.size(), assets);
    }

    @Override
    public BrowseResult<Asset> browseAssets(Repository repository, QueryOptions queryOptions) {
        Preconditions.checkNotNull((Object)repository);
        List<Repository> repositories = this.getRepositories(repository);
        Throwable throwable = null;
        Object var5_6 = null;
        try (StorageTx storageTx = (StorageTx)repository.facet(StorageFacet.class).txSupplier().get();){
            storageTx.begin();
            List<String> bucketIds = this.getBucketIds(storageTx, repositories);
            List<Object> assets = Collections.emptyList();
            if (this.hasAssets(storageTx, repository, bucketIds, queryOptions)) {
                assets = this.getAssets(storageTx.browse(this.browseAssetsSqlBuilder.buildBrowseSql(bucketIds, queryOptions), this.browseAssetsSqlBuilder.buildSqlParams(repository.getName(), queryOptions)));
            }
            return new BrowseResult<Asset>(queryOptions, assets);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean hasAssets(StorageTx storageTx, Repository repository, List<String> bucketIds, QueryOptions queryOptions) {
        QueryOptions adjustedOptions = new QueryOptions(queryOptions.getFilter(), null, null, 0, 1, null, false);
        Iterable<ODocument> docs = storageTx.browse(this.browseAssetsSqlBuilder.buildBrowseSql(bucketIds, adjustedOptions), this.browseAssetsSqlBuilder.buildSqlParams(repository.getName(), adjustedOptions));
        return docs.iterator().hasNext();
    }

    @Override
    public BrowseResult<Asset> previewAssets(RepositorySelector repositorySelector, List<Repository> repositories, String jexlExpression, QueryOptions queryOptions) {
        Preconditions.checkNotNull(repositories);
        Preconditions.checkNotNull((Object)jexlExpression);
        Repository repository = repositories.get(0);
        Throwable throwable = null;
        Object var7_8 = null;
        try (StorageTx storageTx = (StorageTx)repository.facet(StorageFacet.class).txSupplier().get();){
            storageTx.begin();
            List<Repository> previewRepositories = repositories.size() == 1 && this.groupType.equals(repository.getType()) ? repository.facet(GroupFacet.class).leafMembers() : repositories;
            PreviewAssetsSqlBuilder builder = new PreviewAssetsSqlBuilder(repositorySelector, jexlExpression, queryOptions, this.getRepoToContainedGroupMap(repositories));
            String whereClause = String.format("and (%s)", builder.buildWhereClause());
            return new BrowseResult<Asset>(storageTx.countAssets(null, builder.buildSqlParams(), previewRepositories, whereClause), Lists.newArrayList(storageTx.findAssets(null, builder.buildSqlParams(), previewRepositories, String.valueOf(whereClause) + builder.buildQuerySuffix())));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Asset getAssetById(ORID assetId, Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)assetId);
        return this.getById(assetId, repository, "asset", this.assetEntityAdapter);
    }

    @Override
    public Component getComponentById(ORID componentId, Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)componentId);
        return this.getById(componentId, repository, "component", this.componentEntityAdapter);
    }

    @Override
    public Map<EntityId, String> getRepositoryBucketNames(Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        Throwable throwable = null;
        Object var3_4 = null;
        try (StorageTx storageTx = (StorageTx)repository.facet(StorageFacet.class).txSupplier().get();){
            storageTx.begin();
            List<Bucket> buckets = this.getBuckets(storageTx, this.getRepositories(repository));
            return buckets.stream().collect(Collectors.toMap(EntityHelper::id, Bucket::getRepositoryName));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private <T extends MetadataNode<?>> T getById(ORID orid, Repository repository, String tableName, MetadataNodeEntityAdapter<T> adapter) {
        String sql = String.format("SELECT * FROM %s WHERE contentAuth(@this, :browsedRepository) == true AND @RID == :rid", tableName);
        ImmutableMap params = ImmutableMap.of((Object)"browsedRepository", (Object)repository.getName(), (Object)"rid", (Object)orid.toString());
        Throwable throwable = null;
        Object var8_9 = null;
        try (StorageTx storageTx = (StorageTx)repository.facet(StorageFacet.class).txSupplier().get();){
            storageTx.begin();
            return (T)((MetadataNode)StreamSupport.stream(storageTx.browse(sql, (Map<String, Object>)params).spliterator(), false).map(arg_0 -> adapter.readEntity(arg_0)).findFirst().orElse(null));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @VisibleForTesting
    Map<String, List<String>> getRepoToContainedGroupMap(List<Repository> repositories) {
        HashMap<String, List<String>> repoToContainedGroupMap = new HashMap<String, List<String>>();
        for (Repository repository : repositories) {
            ArrayList<String> groupNames = new ArrayList<String>();
            groupNames.add(repository.getName());
            groupNames.addAll(repositories.stream().filter(groupRepository -> {
                Optional<GroupFacet> groupFacet = groupRepository.optionalFacet(GroupFacet.class);
                return groupFacet.isPresent() && groupFacet.get().leafMembers().stream().anyMatch(leafMember -> repository.getName().equals(leafMember.getName()));
            }).map(groupRepository -> groupRepository.getName()).collect(Collectors.toSet()));
            repoToContainedGroupMap.put(repository.getName(), groupNames);
        }
        return repoToContainedGroupMap;
    }

    private List<Repository> getRepositories(Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        if (this.groupType.equals(repository.getType())) {
            return repository.facet(GroupFacet.class).leafMembers();
        }
        return ImmutableList.of((Object)repository);
    }

    private List<Bucket> getBuckets(StorageTx storageTx, Iterable<Repository> repositories) {
        Preconditions.checkNotNull((Object)storageTx);
        Preconditions.checkNotNull(repositories);
        Iterable<Bucket> buckets = storageTx.findBuckets(repositories);
        if (buckets == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList(buckets);
    }

    @VisibleForTesting
    List<String> getBucketIds(StorageTx storageTx, Iterable<Repository> repositories) {
        return Lists.newArrayList((Iterable)Iterables.transform(this.getBuckets(storageTx, repositories), bucket -> AttachedEntityHelper.id((Entity)bucket).toString()));
    }

    private List<Component> getComponents(Iterable<ODocument> results) {
        Preconditions.checkNotNull(results);
        return Lists.newArrayList((Iterable)Iterables.transform(results, arg_0 -> ((ComponentEntityAdapter)this.componentEntityAdapter).readEntity(arg_0)));
    }

    @VisibleForTesting
    List<Asset> getAssets(Iterable<ODocument> results) {
        Preconditions.checkNotNull(results);
        return Lists.newArrayList((Iterable)Iterables.transform(results, arg_0 -> ((AssetEntityAdapter)this.assetEntityAdapter).readEntity(arg_0)));
    }

    @Override
    public Asset getAssetById(EntityId assetId, Repository repository) {
        List<Repository> members = this.allMembers(repository);
        return (Asset)Transactional.operation.withDb(repository.facet(StorageFacet.class).txSupplier()).call(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Asset candidate = tx.findAsset(assetId);
            if (candidate != null) {
                String assetBucketRepositoryName = this.bucketStore.getById(candidate.bucketId()).getRepositoryName();
                if (members.stream().anyMatch(repo -> repo.getName().equals(assetBucketRepositoryName))) {
                    return candidate;
                }
            }
            return null;
        });
    }

    private List<Repository> allMembers(Repository repository) {
        if (this.groupType.equals(repository.getType())) {
            return repository.facet(GroupFacet.class).allMembers();
        }
        return Collections.singletonList(repository);
    }

    @Override
    public long getLastThirtyDays(Asset asset) {
        Preconditions.checkNotNull((Object)asset);
        String repositoryName = this.bucketStore.getById(asset.bucketId()).getRepositoryName();
        if (this.assetDownloadCountStore.isEnabled()) {
            return this.assetDownloadCountStore.getLastThirtyDays(repositoryName, asset.name());
        }
        return 0L;
    }
}

