/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.browse.ComponentPathBrowseNodeGenerator;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;

@Singleton
@Named
public class DefaultBrowseNodeGenerator
extends ComponentPathBrowseNodeGenerator {
    @Override
    public List<String> computeAssetPath(Asset asset, @Nullable Component component) {
        Preconditions.checkNotNull((Object)asset);
        if (component != null) {
            List<String> path = this.computeComponentPath(asset, component);
            path.add(this.lastSegment(asset.name()));
            return path;
        }
        return super.computeAssetPath(asset, null);
    }

    @Override
    public List<String> computeComponentPath(Asset asset, Component component) {
        ArrayList<String> path = new ArrayList<String>();
        if (!Strings2.isBlank((String)component.group())) {
            path.add(component.group());
        }
        path.add(component.name());
        if (!Strings2.isBlank((String)component.version())) {
            path.add(component.version());
        }
        return path;
    }
}

