/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.internal;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonatype.nexus.repository.browse.QueryOptions;
import org.sonatype.nexus.repository.browse.internal.AssetWhereClauseBuilder;
import org.sonatype.nexus.repository.browse.internal.SuffixSqlBuilder;
import org.sonatype.nexus.repository.security.RepositorySelector;

public class PreviewAssetsSqlBuilder {
    private final RepositorySelector repositorySelector;
    private final String jexlExpression;
    private final QueryOptions queryOptions;
    private final Map<String, List<String>> repoToContainedGroupMap;

    public PreviewAssetsSqlBuilder(RepositorySelector repositorySelector, String jexlExpression, QueryOptions queryOptions, Map<String, List<String>> repoToContainedGroupMap) {
        this.repositorySelector = (RepositorySelector)Preconditions.checkNotNull((Object)repositorySelector);
        this.jexlExpression = (String)Preconditions.checkNotNull((Object)jexlExpression);
        this.queryOptions = (QueryOptions)Preconditions.checkNotNull((Object)queryOptions);
        this.repoToContainedGroupMap = (Map)Preconditions.checkNotNull(repoToContainedGroupMap);
    }

    public String buildWhereClause() {
        return AssetWhereClauseBuilder.whereClause("contentExpression(@this, :jexlExpression, :repositorySelector, :repoToContainedGroupMap) == true", this.queryOptions.getFilter() != null);
    }

    public String buildQuerySuffix() {
        return SuffixSqlBuilder.buildSuffix(this.queryOptions);
    }

    public Map<String, Object> buildSqlParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("repositorySelector", this.repositorySelector.toSelector());
        params.put("jexlExpression", this.buildJexlExpression());
        params.put("repoToContainedGroupMap", this.repoToContainedGroupMap);
        String filter = this.queryOptions.getFilter();
        if (filter != null) {
            params.put("nameFilter", "%" + filter + "%");
        }
        return params;
    }

    private String buildJexlExpression() {
        return this.jexlExpression.replaceAll("\"", "'").replaceAll("\\s", " ");
    }
}

