/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexCursor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.browse.BrowseNodeConfiguration;
import org.sonatype.nexus.repository.browse.internal.BrowseNodeManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.AssetStore;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.BucketStore;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskInterruptedException;

@Named
public class RebuildBrowseNodesTask
extends RepositoryTaskSupport
implements Cancelable {
    private static final int BUCKET_KEY_ID = 0;
    private final AssetStore assetStore;
    private final BucketStore bucketStore;
    private final BrowseNodeManager browseNodeManager;
    private final int rebuildPageSize;

    @Inject
    public RebuildBrowseNodesTask(AssetStore assetStore, BucketStore bucketStore, BrowseNodeManager browseNodeManager, BrowseNodeConfiguration configuration) {
        this.assetStore = (AssetStore)Preconditions.checkNotNull((Object)assetStore);
        this.bucketStore = (BucketStore)Preconditions.checkNotNull((Object)bucketStore);
        this.browseNodeManager = (BrowseNodeManager)((Object)Preconditions.checkNotNull((Object)((Object)browseNodeManager)));
        this.rebuildPageSize = ((BrowseNodeConfiguration)Preconditions.checkNotNull((Object)configuration)).getRebuildPageSize();
    }

    public String getMessage() {
        return "Rebuilding browse tree for " + this.getRepositoryField();
    }

    @Override
    protected void execute(Repository repo) {
        this.log.info("Deleting browse nodes for repository {}", (Object)repo.getName());
        this.browseNodeManager.deleteByRepository(repo.getName());
        this.log.info("Rebuilding browse nodes for repository {}", (Object)repo.getName());
        Bucket bucket = this.bucketStore.read(repo.getName());
        ORID bucketId = AttachedEntityHelper.id((Entity)bucket);
        try {
            long processed = 0L;
            long total = this.assetStore.countAssets((Iterable<Bucket>)ImmutableList.of((Object)((Object)bucket)));
            if (total > 0L) {
                ProgressLogIntervalHelper progressLogger = new ProgressLogIntervalHelper(this.log, 60);
                Stopwatch sw = Stopwatch.createStarted();
                OIndexCursor cursor = this.assetStore.getIndex(AssetEntityAdapter.I_BUCKET_COMPONENT_NAME).cursor();
                List nextPage = this.assetStore.getNextPage(cursor, this.rebuildPageSize);
                while (!Iterables.isEmpty(nextPage)) {
                    this.checkContinuation(repo);
                    ArrayList<Asset> assets = new ArrayList<Asset>(this.rebuildPageSize);
                    for (Map.Entry indexEntry : nextPage) {
                        if (!bucketId.equals(((OCompositeKey)indexEntry.getKey()).getKeys().get(0))) continue;
                        assets.add(this.assetStore.getById(indexEntry.getValue()));
                    }
                    int assetsSize = Iterables.size(assets);
                    this.browseNodeManager.createFromAssets(repo, assets);
                    long elapsed = sw.elapsed(TimeUnit.MILLISECONDS);
                    progressLogger.info("Rebuilt {} / {} browse nodes in {} ms", new Object[]{processed += (long)assetsSize, total, elapsed});
                    nextPage = this.assetStore.getNextPage(cursor, this.rebuildPageSize);
                }
                progressLogger.flush();
            }
        }
        catch (Exception e) {
            this.log.error("Could not re-create browse nodes for repository: {}", (Object)repo, (Object)e);
        }
    }

    @Override
    protected boolean appliesTo(Repository repository) {
        return repository != null;
    }

    private void checkContinuation(Repository repo) {
        if (this.isCanceled()) {
            throw new TaskInterruptedException(String.format("Rebuilding browse nodes was cancelled for %s", repo.getName()), true);
        }
    }
}

