/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.internal.resources;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.shiro.authz.Permission;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.encoding.EncodingUtil;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.template.EscapeHelper;
import org.sonatype.nexus.common.template.TemplateHelper;
import org.sonatype.nexus.common.template.TemplateParameters;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.browse.BrowseNodeConfiguration;
import org.sonatype.nexus.repository.browse.internal.model.BrowseListItem;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.security.RepositoryViewPermission;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.BrowseNode;
import org.sonatype.nexus.repository.storage.BrowseNodeStore;
import org.sonatype.nexus.repository.storage.BucketStore;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
@Path(value="/repository/browse/{repositoryName}{noop: (/)?}{repositoryPath: ((?<=/).*)?}")
@Produces(value={"text/html"})
public class RepositoryBrowseResource
extends ComponentSupport
implements Resource {
    private static final String REPOSITORY_PATH_SEGMENT = "{noop: (/)?}{repositoryPath: ((?<=/).*)?}";
    public static final String RESOURCE_URI = "/repository/browse/{repositoryName}{noop: (/)?}{repositoryPath: ((?<=/).*)?}";
    private static final String TEMPLATE_RESOURCE = "browseContentHtml.vm";
    private final RepositoryManager repositoryManager;
    private final BrowseNodeStore browseNodeStore;
    private final BrowseNodeConfiguration configuration;
    private final TemplateHelper templateHelper;
    private final SecurityHelper securityHelper;
    private final URL template;
    private final BucketStore bucketStore;
    private final EscapeHelper escapeHelper = new EscapeHelper();

    @Inject
    public RepositoryBrowseResource(RepositoryManager repositoryManager, BrowseNodeStore browseNodeStore, BrowseNodeConfiguration configuration, BucketStore bucketStore, TemplateHelper templateHelper, SecurityHelper securityHelper) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.browseNodeStore = (BrowseNodeStore)Preconditions.checkNotNull((Object)browseNodeStore);
        this.configuration = (BrowseNodeConfiguration)Preconditions.checkNotNull((Object)configuration);
        this.templateHelper = (TemplateHelper)Preconditions.checkNotNull((Object)templateHelper);
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
        this.bucketStore = (BucketStore)Preconditions.checkNotNull((Object)bucketStore);
        this.template = ((Object)((Object)this)).getClass().getResource(TEMPLATE_RESOURCE);
        Preconditions.checkNotNull((Object)this.template);
    }

    @GET
    public Response getHtml(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="repositoryPath") String repositoryPath, @QueryParam(value="filter") String filter, @Context UriInfo uriInfo) {
        List<BrowseListItem> listItems;
        this.log.debug("Get HTML directory listing for repository {} on path {}", (Object)repositoryName, (Object)repositoryPath);
        if (!uriInfo.getAbsolutePath().toString().endsWith("/")) {
            this.log.debug("Request does include a trailing slash, redirecting to include it");
            return Response.seeOther((URI)UriBuilder.fromUri((URI)uriInfo.getAbsolutePath()).path("/").build(new Object[0])).build();
        }
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository == null) {
            throw this.createNotFoundException(repositoryName, null);
        }
        List<String> pathSegments = new ArrayList<String>();
        if (!this.isRoot(repositoryPath)) {
            pathSegments = Arrays.asList(repositoryPath.split("/"));
        }
        Iterable<BrowseNode> browseNodes = this.browseNodeStore.getByPath(repository, pathSegments, this.configuration.getMaxHtmlNodes(), filter);
        boolean permitted = this.securityHelper.allPermitted(new Permission[]{new RepositoryViewPermission(repository, "browse")});
        boolean hasChildren = browseNodes != null && !Iterables.isEmpty(browseNodes);
        List<BrowseListItem> list = listItems = hasChildren ? this.toListItems(browseNodes, repository, repositoryPath, filter) : Collections.emptyList();
        if (hasChildren || this.isRoot(repositoryPath) && permitted) {
            return Response.ok((Object)this.templateHelper.render(this.template, this.initializeTemplateParameters(repositoryName, repositoryPath, listItems))).build();
        }
        throw this.createNotFoundException(repositoryName, permitted ? repositoryPath : null);
    }

    private WebApplicationException createNotFoundException(String repositoryName, String repositoryPath) {
        if (repositoryPath == null) {
            this.log.debug("Requested repository could not be located or user does not have permission: {} ", (Object)repositoryName);
            return new WebApplicationException("Repository not found", Response.Status.NOT_FOUND);
        }
        this.log.debug("Requested path {} could not be located in repository {}", (Object)repositoryPath, (Object)repositoryName);
        return new WebApplicationException("Path not found", Response.Status.NOT_FOUND);
    }

    private List<BrowseListItem> toListItems(Iterable<BrowseNode> browseNodes, Repository repository, String path, String filter) {
        ArrayList<BrowseListItem> listItems = new ArrayList<BrowseListItem>();
        if (browseNodes != null) {
            SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
            for (BrowseNode browseNode : browseNodes) {
                String listItemPath;
                String size = null;
                String lastModified = null;
                if (browseNode.isLeaf()) {
                    Asset asset = this.getAssetById(repository, browseNode.getAssetId());
                    if (asset == null) {
                        this.log.error("Could not find expected asset (id): {}/{} ({}) in repository: {}", new Object[]{path, browseNode.getName(), browseNode.getAssetId().toString(), repository.getName()});
                        continue;
                    }
                    size = String.valueOf(asset.size());
                    lastModified = Optional.ofNullable(asset.blobUpdated()).map(dateTime -> format.format(dateTime.toDate())).orElse("");
                    listItemPath = this.getListItemPath(repository, browseNode, asset, filter);
                } else {
                    listItemPath = this.getListItemPath(repository, browseNode, null, filter);
                }
                listItems.add(new BrowseListItem(listItemPath, browseNode.getName(), !browseNode.isLeaf(), lastModified, size, ""));
            }
        }
        return listItems;
    }

    private Asset getAssetById(Repository repository, EntityId assetId) {
        Optional<GroupFacet> optionalGroupFacet = repository.optionalFacet(GroupFacet.class);
        List<Repository> members = optionalGroupFacet.isPresent() ? optionalGroupFacet.get().allMembers() : Collections.singletonList(repository);
        return (Asset)Transactional.operation.withDb(repository.facet(StorageFacet.class).txSupplier()).call(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Asset candidate = tx.findAsset(assetId);
            if (candidate != null) {
                String asssetBucketRepositoryName = this.bucketStore.getById(candidate.bucketId()).getRepositoryName();
                if (members.stream().anyMatch(repo -> repo.getName().equals(asssetBucketRepositoryName))) {
                    return candidate;
                }
            }
            return null;
        });
    }

    private TemplateParameters initializeTemplateParameters(String repositoryName, String path, List<BrowseListItem> listItems) {
        TemplateParameters templateParameters = this.templateHelper.parameters();
        if (this.isRoot(path)) {
            templateParameters.set("root", (Object)true);
        }
        templateParameters.set("requestPath", (Object)("/" + path));
        templateParameters.set("listItems", listItems);
        templateParameters.set("showMoreContentWarning", (Object)(this.configuration.getMaxHtmlNodes() == listItems.size() ? 1 : 0));
        if (Strings2.isBlank((String)path)) {
            templateParameters.set("encodedPath", (Object)String.format("/#browse/browse:%s", repositoryName));
        } else {
            String encodedPath = EncodingUtil.urlEncode((String)("/" + path + "/"));
            templateParameters.set("encodedPath", (Object)String.format("/#browse/browse:%s:%s", repositoryName, encodedPath));
        }
        templateParameters.set("searchUrl", (Object)"/#browse/search");
        return templateParameters;
    }

    private String getListItemPath(Repository repository, BrowseNode browseNode, Asset asset, String filter) {
        String filterParam = filter == null ? "" : "?filter=" + URLEncoder.encode(filter);
        String listItemPath = asset == null ? String.valueOf(this.escapeHelper.uri(browseNode.getName())) + "/" + filterParam : String.valueOf(repository.getUrl()) + "/" + Stream.of(asset.name().split("/")).map(arg_0 -> ((EscapeHelper)this.escapeHelper).uri(arg_0)).collect(Collectors.joining("/"));
        return listItemPath;
    }

    private boolean isRoot(String path) {
        return Strings2.isBlank((String)path);
    }
}

