/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.cache;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.cache.CacheInfo;

public class CacheController
extends ComponentSupport {
    private final int contentMaxAgeSeconds;
    private volatile String cacheToken;

    public static String newCacheToken() {
        return Long.toString(System.nanoTime());
    }

    public CacheController(int contentMaxAgeSeconds, @Nullable String cacheToken) {
        this.contentMaxAgeSeconds = contentMaxAgeSeconds;
        this.cacheToken = cacheToken;
    }

    public void invalidateCache() {
        this.cacheToken = CacheController.newCacheToken();
    }

    public CacheInfo current() {
        return new CacheInfo(DateTime.now(), this.cacheToken);
    }

    public boolean isStale(CacheInfo cacheInfo) {
        if (cacheInfo.isInvalidated()) {
            this.log.debug("Content invalidated");
            return true;
        }
        if (this.cacheToken != null && !this.cacheToken.equals(cacheInfo.getCacheToken())) {
            this.log.debug("Content expired (cacheToken)");
            return true;
        }
        if (this.contentMaxAgeSeconds < 0) {
            this.log.trace("Content max age checking disabled");
            return false;
        }
        if (cacheInfo.getLastVerified().isBefore((ReadableInstant)new DateTime().minusSeconds(this.contentMaxAgeSeconds))) {
            this.log.debug("Content expired (age)");
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public int getContentMaxAgeSeconds() {
        return this.contentMaxAgeSeconds;
    }
}

