/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.cache;

import com.google.common.base.Preconditions;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.NegativeCacheFacet;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.proxy.ProxyFacet;

public final class RepositoryCacheUtils {
    private RepositoryCacheUtils() {
    }

    public static void invalidateCaches(Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        if ("group".equals(repository.getType().getValue())) {
            RepositoryCacheUtils.invalidateGroupCaches(repository);
        } else if ("proxy".equals(repository.getType().getValue())) {
            RepositoryCacheUtils.invalidateProxyAndNegativeCaches(repository);
        }
    }

    public static void invalidateGroupCaches(Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkArgument((boolean)"group".equals(repository.getType().getValue()));
        GroupFacet groupFacet = repository.facet(GroupFacet.class);
        groupFacet.invalidateGroupCaches();
    }

    public static void invalidateProxyAndNegativeCaches(Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkArgument((boolean)"proxy".equals(repository.getType().getValue()));
        ProxyFacet proxyFacet = repository.facet(ProxyFacet.class);
        proxyFacet.invalidateProxyCaches();
        NegativeCacheFacet negativeCacheFacet = repository.facet(NegativeCacheFacet.class);
        negativeCacheFacet.invalidate();
    }
}

