/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.cache.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.cache.CacheHelper;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.cache.NegativeCacheFacet;
import org.sonatype.nexus.repository.cache.NegativeCacheKey;
import org.sonatype.nexus.repository.cache.internal.PathNegativeCacheKey;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Status;

@Named
public class NegativeCacheFacetImpl
extends FacetSupport
implements NegativeCacheFacet {
    private final CacheHelper cacheHelper;
    @VisibleForTesting
    static final String CONFIG_KEY = "negativeCache";
    private Config config;
    private Cache<NegativeCacheKey, Status> cache;

    @Inject
    public NegativeCacheFacetImpl(CacheHelper cacheHelper) {
        this.cacheHelper = (CacheHelper)Preconditions.checkNotNull((Object)cacheHelper);
    }

    @Override
    protected void doValidate(Configuration configuration) throws Exception {
        this.facet(ConfigurationFacet.class).validateSection(configuration, CONFIG_KEY, Config.class, new Class[0]);
    }

    @Override
    protected void doConfigure(Configuration configuration) throws Exception {
        this.config = this.facet(ConfigurationFacet.class).readSection(configuration, CONFIG_KEY, Config.class);
        this.log.debug("Config: {}", (Object)this.config);
    }

    @Override
    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        if (this.config.enabled.booleanValue()) {
            this.maybeCreateCache();
        }
    }

    @Override
    protected void doUpdate(Configuration configuration) throws Exception {
        Config previous = this.config;
        super.doUpdate(configuration);
        if (this.config.enabled.booleanValue()) {
            if (!previous.enabled.booleanValue() || !this.config.timeToLive.equals(previous.timeToLive)) {
                this.maybeDestroyCache();
                this.maybeCreateCache();
            }
        } else {
            this.maybeDestroyCache();
        }
    }

    @Override
    protected void doDelete() throws Exception {
        this.maybeDestroyCache();
        this.config = null;
    }

    @Override
    protected void doDestroy() throws Exception {
        this.cache = null;
        this.config = null;
    }

    private void maybeCreateCache() {
        if (this.cache == null) {
            this.log.debug("Creating negative-cache for: {}", (Object)this.getRepository());
            this.cache = this.cacheHelper.maybeCreateCache(this.getCacheName(), NegativeCacheKey.class, Status.class, CreatedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.MINUTES, (long)this.config.timeToLive.intValue())));
            this.log.debug("Created negative-cache: {}", this.cache);
        }
    }

    private void maybeDestroyCache() {
        this.log.debug("Destroying negative-cache for: {}", (Object)this.getRepository());
        this.cacheHelper.maybeDestroyCache(this.getCacheName());
        this.cache = null;
    }

    @Override
    @Guarded(by={"STARTED"})
    public Status get(NegativeCacheKey key) {
        Preconditions.checkNotNull((Object)key);
        if (this.cache != null) {
            return (Status)this.cache.get((Object)key);
        }
        return null;
    }

    @Override
    @Guarded(by={"STARTED"})
    public void put(NegativeCacheKey key, Status status) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)status);
        if (this.cache != null) {
            this.log.debug("Adding {}={} to negative-cache of {}", new Object[]{key, status, this.getRepository()});
            this.cache.put((Object)key, (Object)status);
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public void invalidate(NegativeCacheKey key) {
        Preconditions.checkNotNull((Object)key);
        if (this.cache != null && this.cache.remove((Object)key)) {
            this.log.debug("Removing {} from negative-cache of {}", (Object)key, (Object)this.getRepository());
        }
    }

    @Override
    public void invalidateSubset(NegativeCacheKey key) {
        if (this.cache != null) {
            this.invalidate(key);
            for (Cache.Entry entry : this.cache) {
                if (key.equals(entry.getKey()) || !key.isParentOf((NegativeCacheKey)entry.getKey())) continue;
                this.invalidate((NegativeCacheKey)entry.getKey());
            }
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public void invalidate() {
        if (this.cache != null) {
            this.log.debug("Removing all from negative-cache of {}", (Object)this.getRepository());
            this.cache.removeAll();
        }
    }

    @Override
    public NegativeCacheKey getCacheKey(Context context) {
        return new PathNegativeCacheKey(context.getRequest().getPath());
    }

    public String getCacheName() {
        return String.valueOf(this.getRepository().getName()) + "#negative-cache";
    }

    @VisibleForTesting
    static class Config {
        @NotNull
        public Boolean enabled = Boolean.TRUE;
        @NotNull
        @Min(value=0L)
        public Integer timeToLive = Time.hours((long)24L).toMinutesI();

        Config() {
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "enabled=" + this.enabled + ", timeToLive=" + this.timeToLive + '}';
        }
    }
}

