/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.cache.internal;

import com.google.common.base.Preconditions;
import org.sonatype.nexus.repository.cache.NegativeCacheKey;

public class PathNegativeCacheKey
implements NegativeCacheKey {
    private final String path;

    public PathNegativeCacheKey(String path) {
        this.path = (String)Preconditions.checkNotNull((Object)path);
    }

    @Override
    public boolean isParentOf(NegativeCacheKey key) {
        Preconditions.checkNotNull((Object)key);
        return this.path.endsWith("/") && key instanceof PathNegativeCacheKey && ((PathNegativeCacheKey)key).path.startsWith(this.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathNegativeCacheKey that = (PathNegativeCacheKey)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "path='" + this.path + '\'' + '}';
    }
}

