/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.capability.internal;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.function.Supplier;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.repository.capability.internal.RepositoryConditionSupport;
import org.sonatype.nexus.repository.manager.RepositoryCreatedEvent;
import org.sonatype.nexus.repository.manager.RepositoryDeletedEvent;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.manager.RepositoryUpdatedEvent;

public class RepositoryOnlineCondition
extends RepositoryConditionSupport {
    public RepositoryOnlineCondition(EventManager eventManager, RepositoryManager repositoryManager, Supplier<String> repositoryName) {
        super(eventManager, repositoryManager, repositoryName);
    }

    @Override
    @AllowConcurrentEvents
    @Subscribe
    public void handle(RepositoryCreatedEvent event) {
        if (this.sameRepositoryAs(event.getRepository().getName())) {
            this.setSatisfied(event.getRepository().getConfiguration().isOnline());
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(RepositoryUpdatedEvent event) {
        if (this.sameRepositoryAs(event.getRepository().getName())) {
            this.setSatisfied(event.getRepository().getConfiguration().isOnline());
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(RepositoryDeletedEvent event) {
        if (this.sameRepositoryAs(event.getRepository().getName())) {
            this.setSatisfied(false);
        }
    }

    public String toString() {
        try {
            String repositoryName = this.getRepositoryName();
            return String.format("Repository '%s' is online", repositoryName);
        }
        catch (Exception exception) {
            return "Repository '(could not be evaluated)' is online";
        }
    }

    public String explainSatisfied() {
        try {
            String repositoryName = this.getRepositoryName();
            return String.format("Repository '%s' is online", repositoryName);
        }
        catch (Exception exception) {
            return "Repository '(could not be evaluated)' is online";
        }
    }

    public String explainUnsatisfied() {
        try {
            String repositoryName = this.getRepositoryName();
            return String.format("Repository '%s' is offline", repositoryName);
        }
        catch (Exception exception) {
            return "Repository '(could not be evaluated)' is offline";
        }
    }
}

