/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.collect.DetachingList;
import org.sonatype.nexus.common.collect.DetachingMap;
import org.sonatype.nexus.common.collect.DetachingSet;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.AbstractEntity;
import org.sonatype.nexus.common.io.SanitizingJsonOutputStream;
import org.sonatype.nexus.common.text.Strings2;

public class Configuration
extends AbstractEntity
implements Cloneable {
    private static final List<String> SENSITIVE_FIELD_NAMES = Lists.newArrayList((Object[])new String[]{"applicationPassword", "password", "systemPassword", "secret"});
    private static final TypeReference<Map<String, Map<String, Object>>> ATTRIBUTES_TYPE_REF = new TypeReference<Map<String, Map<String, Object>>>(){};
    private static final ObjectWriter ATTRIBUTES_JSON_WRITER = new ObjectMapper().writerFor(ATTRIBUTES_TYPE_REF);
    private static final ObjectReader ATTRIBUTES_JSON_READER = new ObjectMapper().readerFor(ATTRIBUTES_TYPE_REF);
    private Logger log = LoggerFactory.getLogger(Configuration.class);
    private String repositoryName;
    private String recipeName;
    private boolean online;
    private Map<String, Map<String, Object>> attributes;

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = (String)Preconditions.checkNotNull((Object)repositoryName);
    }

    public String getRecipeName() {
        return this.recipeName;
    }

    public void setRecipeName(String recipeName) {
        this.recipeName = (String)Preconditions.checkNotNull((Object)recipeName);
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    @Nullable
    public Map<String, Map<String, Object>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(@Nullable Map<String, Map<String, Object>> attributes) {
        this.attributes = attributes;
    }

    public NestedAttributesMap attributes(String key) {
        HashMap map;
        Preconditions.checkNotNull((Object)key);
        if (this.attributes == null) {
            this.attributes = Maps.newHashMap();
        }
        if ((map = this.attributes.get(key)) == null) {
            map = Maps.newHashMap();
            this.attributes.put(key, map);
        }
        return new NestedAttributesMap(key, (Map)map);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "repositoryName='" + this.repositoryName + '\'' + ", recipeName='" + this.recipeName + '\'' + ", attributes=" + this.obfuscatedAttributes() + '}';
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String obfuscatedAttributes() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayOutputStream obfuscatedAttrs = new ByteArrayOutputStream();){
                Throwable throwable2 = null;
                Object var5_9 = null;
                try (SanitizingJsonOutputStream sanitizer = new SanitizingJsonOutputStream((OutputStream)obfuscatedAttrs, SENSITIVE_FIELD_NAMES, Strings2.mask((String)"password"));){
                    sanitizer.write(ATTRIBUTES_JSON_WRITER.writeValueAsBytes(this.attributes));
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                        throw throwable2;
                    }
                    if (throwable2 == throwable3) throw throwable2;
                    throwable2.addSuppressed(throwable3);
                    throw throwable2;
                }
                Object result = ATTRIBUTES_JSON_READER.readValue(obfuscatedAttrs.toByteArray());
                return result != null ? result.toString() : "";
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.error("Error obfuscating attributes", (Throwable)e);
            return String.format("<<Unable to obfuscate attributes. Exception was '%s'>>", e.getMessage());
        }
    }

    public Configuration copy() {
        try {
            Configuration c = (Configuration)this.clone();
            c.attributes = this.copy(this.attributes);
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private <V> V copy(V value) {
        Object copy = value;
        if (value instanceof Map) {
            copy = new DetachingMap((Map)value, this::copy);
        } else if (value instanceof List) {
            copy = new DetachingList((List)value, this::copy);
        } else if (value instanceof Set) {
            copy = new DetachingSet((Set)value, this::copy);
        }
        return copy;
    }
}

