/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.config.internal;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.collate.OCaseInsensitiveCollate;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.AttachedEntityMetadata;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.internal.ConfigurationCreatedEvent;
import org.sonatype.nexus.repository.config.internal.ConfigurationDeletedEvent;
import org.sonatype.nexus.repository.config.internal.ConfigurationUpdatedEvent;
import org.sonatype.nexus.security.PasswordHelper;

@Named
@Singleton
public class ConfigurationEntityAdapter
extends IterableEntityAdapter<Configuration> {
    private static final String DB_CLASS = new OClassNameBuilder().type("repository").build();
    private static final String P_REPOSITORY_NAME = "repository_name";
    private static final String P_RECIPE_NAME = "recipe_name";
    private static final String P_ONLINE = "online";
    private static final String P_ATTRIBUTES = "attributes";
    private static final String I_REPOSITORY_NAME = new OIndexNameBuilder().type(DB_CLASS).property("repository_name").build();
    private final PasswordHelper passwordHelper;

    @Inject
    public ConfigurationEntityAdapter(PasswordHelper passwordHelper) {
        super(DB_CLASS);
        this.passwordHelper = (PasswordHelper)Preconditions.checkNotNull((Object)passwordHelper);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_REPOSITORY_NAME, OType.STRING).setCollate((OCollate)new OCaseInsensitiveCollate()).setMandatory(true).setNotNull(true);
        type.createProperty(P_RECIPE_NAME, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_ONLINE, OType.BOOLEAN).setMandatory(true).setNotNull(true);
        type.createProperty(P_ATTRIBUTES, OType.EMBEDDEDMAP);
        type.createIndex(I_REPOSITORY_NAME, OClass.INDEX_TYPE.UNIQUE, new String[]{P_REPOSITORY_NAME});
    }

    protected Configuration newEntity() {
        return new Configuration();
    }

    protected void readFields(ODocument document, Configuration entity) {
        String recipeName = (String)document.field(P_RECIPE_NAME, OType.STRING);
        String repositoryName = (String)document.field(P_REPOSITORY_NAME, OType.STRING);
        Boolean online = (Boolean)document.field(P_ONLINE, OType.BOOLEAN);
        Map attributes = (Map)document.field(P_ATTRIBUTES, OType.EMBEDDEDMAP);
        entity.setRecipeName(recipeName);
        entity.setRepositoryName(repositoryName);
        entity.setOnline(online);
        entity.setAttributes(this.decrypt(attributes));
    }

    private Map<String, Map<String, Object>> decrypt(Map<String, Map<String, Object>> attributes) {
        return this.process(attributes, arg_0 -> ((PasswordHelper)this.passwordHelper).tryDecrypt(arg_0));
    }

    protected void writeFields(ODocument document, Configuration entity) {
        Map<String, Map<String, Object>> attributes = entity.getAttributes();
        document.field(P_RECIPE_NAME, (Object)entity.getRecipeName());
        document.field(P_REPOSITORY_NAME, (Object)entity.getRepositoryName());
        document.field(P_ONLINE, (Object)entity.isOnline());
        document.field(P_ATTRIBUTES, this.encrypt(attributes));
    }

    private Map<String, Map<String, Object>> encrypt(Map<String, Map<String, Object>> attributes) {
        return this.process(attributes, arg_0 -> ((PasswordHelper)this.passwordHelper).encrypt(arg_0));
    }

    @Nullable
    private <V> Map<String, V> process(@Nullable Map<String, V> map, Function<String, String> transform) {
        if (map == null) {
            return null;
        }
        HashMap<String, V> processed = new HashMap<String, V>(map.size());
        for (Map.Entry<String, V> entry : map.entrySet()) {
            Object value = entry.getValue();
            value = value instanceof Map ? this.process((Map)value, transform) : (this.isSensitiveEntry(entry) ? transform.apply((String)value) : this.detach(value));
            processed.put(entry.getKey(), value);
        }
        return processed;
    }

    private boolean isSensitiveEntry(Map.Entry<String, ?> entry) {
        return entry.getKey().toLowerCase(Locale.ENGLISH).endsWith("password") && entry.getValue() instanceof String;
    }

    public boolean sendEvents() {
        return true;
    }

    @Nullable
    public EntityEvent newEvent(ODocument document, EntityAdapter.EventKind eventKind) {
        AttachedEntityMetadata metadata = new AttachedEntityMetadata((EntityAdapter)this, document);
        String repositoryName = (String)document.field(P_REPOSITORY_NAME);
        this.log.trace("newEvent: eventKind: {}, repositoryName: {}, metadata: {}", new Object[]{eventKind, repositoryName, metadata});
        switch (eventKind) {
            case CREATE: {
                return new ConfigurationCreatedEvent((EntityMetadata)metadata, repositoryName);
            }
            case UPDATE: {
                return new ConfigurationUpdatedEvent((EntityMetadata)metadata, repositoryName);
            }
            case DELETE: {
                return new ConfigurationDeletedEvent((EntityMetadata)metadata, repositoryName);
            }
        }
        return null;
    }
}

