/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.http;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.utils.DateUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.sonatype.nexus.repository.view.Headers;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;

public class HttpConditions {
    private static final String HTTP_CONDITIONS = String.valueOf(HttpConditions.class.getName()) + ".conditions";
    private static final List<String> SUPPORTED_HEADERS = Arrays.asList("If-Modified-Since", "If-Unmodified-Since", "If-Match", "If-None-Match");

    private HttpConditions() {
    }

    @Nonnull
    public static Request makeUnconditional(@Nonnull Request request) {
        Preconditions.checkNotNull((Object)request);
        Headers stashedHeaders = new Headers();
        for (String httpHeader : SUPPORTED_HEADERS) {
            List headerValues = request.getHeaders().getAll(httpHeader);
            if (headerValues != null) {
                stashedHeaders.set(httpHeader, headerValues);
            }
            request.getHeaders().remove(httpHeader);
        }
        request.getAttributes().set(HTTP_CONDITIONS, (Object)stashedHeaders);
        return request;
    }

    @Nonnull
    public static Request makeConditional(@Nonnull Request request) {
        Preconditions.checkNotNull((Object)request);
        Headers stashedHeaders = (Headers)((Object)request.getAttributes().require(HTTP_CONDITIONS, Headers.class));
        for (Map.Entry entry : stashedHeaders.entries()) {
            request.getHeaders().set((String)entry.getKey(), stashedHeaders.getAll((String)entry.getKey()));
        }
        return request;
    }

    @Nullable
    public static Predicate<Response> requestPredicate(@Nonnull Request request) {
        Predicate<Response> ifNoneMatch;
        Predicate<Response> ifMatch;
        Predicate<Response> ifUnmodifiedSince;
        Preconditions.checkNotNull((Object)request);
        ArrayList<Predicate<Response>> predicates = new ArrayList<Predicate<Response>>();
        Predicate<Response> ifModifiedSince = HttpConditions.ifModifiedSince(request);
        if (ifModifiedSince != null) {
            predicates.add(ifModifiedSince);
        }
        if ((ifUnmodifiedSince = HttpConditions.ifUnmodifiedSince(request)) != null) {
            predicates.add(ifUnmodifiedSince);
        }
        if ((ifMatch = HttpConditions.ifMatch(request)) != null) {
            predicates.add(ifMatch);
        }
        if ((ifNoneMatch = HttpConditions.ifNoneMatch(request)) != null) {
            predicates.add(ifNoneMatch);
        }
        if (!predicates.isEmpty()) {
            return Predicates.and(predicates);
        }
        return null;
    }

    @Nullable
    private static Predicate<Response> ifModifiedSince(Request request) {
        final DateTime date = HttpConditions.parseDateHeader(request.getHeaders().get("If-Modified-Since"));
        if (date != null) {
            return new Predicate<Response>(){

                public boolean apply(Response response) {
                    DateTime lastModified = HttpConditions.parseDateHeader(response.getHeaders().get("Last-Modified"));
                    if (lastModified != null) {
                        return lastModified.isAfter((ReadableInstant)date);
                    }
                    return true;
                }

                public String toString() {
                    return String.valueOf(HttpConditions.class.getSimpleName()) + ".ifModifiedSince(" + date + ")";
                }
            };
        }
        return null;
    }

    @Nullable
    private static Predicate<Response> ifUnmodifiedSince(Request request) {
        final DateTime date = HttpConditions.parseDateHeader(request.getHeaders().get("If-Unmodified-Since"));
        if (date != null) {
            return new Predicate<Response>(){

                public boolean apply(Response response) {
                    DateTime lastModified = HttpConditions.parseDateHeader(response.getHeaders().get("Last-Modified"));
                    if (lastModified != null) {
                        return !lastModified.isAfter((ReadableInstant)date);
                    }
                    return true;
                }

                public String toString() {
                    return String.valueOf(HttpConditions.class.getSimpleName()) + ".ifUnmodifiedSince(" + date + ")";
                }
            };
        }
        return null;
    }

    @Nullable
    private static Predicate<Response> ifMatch(Request request) {
        final String match = request.getHeaders().get("If-Match");
        if (match != null && !"*".equals(match)) {
            return new Predicate<Response>(){

                public boolean apply(Response response) {
                    String etag = response.getHeaders().get("ETag");
                    if (etag != null) {
                        return match.contains(etag);
                    }
                    return true;
                }

                public String toString() {
                    return String.valueOf(HttpConditions.class.getSimpleName()) + ".ifMatch(" + match + ")";
                }
            };
        }
        return null;
    }

    @Nullable
    private static Predicate<Response> ifNoneMatch(Request request) {
        final String match = request.getHeaders().get("If-None-Match");
        if (match != null && !"*".equals(match)) {
            return new Predicate<Response>(){

                public boolean apply(Response response) {
                    String etag = response.getHeaders().get("ETag");
                    if (etag != null) {
                        return !match.contains(etag);
                    }
                    return true;
                }

                public String toString() {
                    return String.valueOf(HttpConditions.class.getSimpleName()) + ".ifNoneMatch(" + match + ")";
                }
            };
        }
        return null;
    }

    @Nullable
    private static DateTime parseDateHeader(@Nullable String httpDate) {
        Date date;
        if (!Strings.isNullOrEmpty((String)httpDate) && (date = DateUtils.parseDate((String)httpDate)) != null) {
            return new DateTime(date.getTime());
        }
        return null;
    }
}

