/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.http;

import com.google.common.collect.Range;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.view.Payload;

class PartialPayload
implements Payload {
    private final Payload payload;
    private final Range<Long> rangeToSend;
    private final long partialSize;

    public PartialPayload(Payload payload, Range<Long> rangeToSend) {
        this.payload = payload;
        this.rangeToSend = rangeToSend;
        this.partialSize = 1L + (Long)rangeToSend.upperEndpoint() - (Long)rangeToSend.lowerEndpoint();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        InputStream payloadStream = this.payload.openInputStream();
        payloadStream.skip((Long)this.rangeToSend.lowerEndpoint());
        return ByteStreams.limit((InputStream)payloadStream, (long)this.partialSize);
    }

    @Override
    public long getSize() {
        return this.partialSize;
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.payload.getContentType();
    }
}

