/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.httpclient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public abstract class FilteredHttpClientSupport
extends CloseableHttpClient {
    private final CloseableHttpClient delegate;

    public FilteredHttpClientSupport(CloseableHttpClient delegate) {
        this.delegate = (CloseableHttpClient)Preconditions.checkNotNull((Object)delegate);
    }

    public HttpParams getParams() {
        return this.delegate.getParams();
    }

    public ClientConnectionManager getConnectionManager() {
        return this.delegate.getConnectionManager();
    }

    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        return this.filter(target, () -> this.delegate.execute(target, request, context));
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    protected abstract CloseableHttpResponse filter(HttpHost var1, Filterable var2) throws IOException;

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "delegate=" + this.delegate + '}';
    }

    @VisibleForTesting
    public static interface Filterable {
        public CloseableHttpResponse call() throws IOException;
    }
}

